/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.message.context.MessageContext;
import org.ros.internal.message.context.MessageContextProvider;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;
import org.ros.internal.message.field.MessageFields;
import org.ros.internal.message.field.PrimitiveFieldType;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageFactory;

public class MessageInterfaceBuilder {
    private MessageDeclaration messageDeclaration;
    private String packageName;
    private String interfaceName;
    private boolean addConstantsAndMethods;
    private String nestedContent;

    private static String escapeJava(String str) {
        return StringEscapeUtils.escapeJava((String)str).replace("\\/", "/").replace("'", "\\'");
    }

    public MessageDeclaration getMessageDeclaration() {
        return this.messageDeclaration;
    }

    public MessageInterfaceBuilder setMessageDeclaration(MessageDeclaration messageDeclaration) {
        Preconditions.checkNotNull((Object)messageDeclaration);
        this.messageDeclaration = messageDeclaration;
        return this;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public MessageInterfaceBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public MessageInterfaceBuilder setInterfaceName(String interfaceName) {
        Preconditions.checkNotNull((Object)interfaceName);
        this.interfaceName = interfaceName;
        return this;
    }

    public boolean getAddConstantsAndMethods() {
        return this.addConstantsAndMethods;
    }

    public void setAddConstantsAndMethods(boolean enabled) {
        this.addConstantsAndMethods = enabled;
    }

    public String getNestedContent() {
        return this.nestedContent;
    }

    public void setNestedContent(String nestedContent) {
        this.nestedContent = nestedContent;
    }

    public String build(MessageFactory messageFactory) {
        Preconditions.checkNotNull((Object)this.messageDeclaration);
        Preconditions.checkNotNull((Object)this.interfaceName);
        StringBuilder builder = new StringBuilder();
        if (this.packageName != null) {
            builder.append(String.format("package %s;\n\n", this.packageName));
        }
        builder.append(String.format("public interface %s extends org.ros.internal.message.Message {\n", this.interfaceName));
        builder.append(String.format("  static final java.lang.String _TYPE = \"%s\";\n", this.messageDeclaration.getType()));
        builder.append(String.format("  static final java.lang.String _DEFINITION = \"%s\";\n", MessageInterfaceBuilder.escapeJava(this.messageDeclaration.getDefinition())));
        if (this.addConstantsAndMethods) {
            MessageContextProvider messageContextProvider = new MessageContextProvider(messageFactory);
            MessageContext messageContext = messageContextProvider.get(this.messageDeclaration);
            this.appendConstants(messageContext, builder);
            this.appendSettersAndGetters(messageContext, builder);
        }
        if (this.nestedContent != null) {
            builder.append("\n");
            builder.append(this.nestedContent);
        }
        builder.append("}\n");
        return builder.toString();
    }

    private String getJavaValue(PrimitiveFieldType primitiveFieldType, String value) {
        switch (primitiveFieldType) {
            case BOOL: {
                return Boolean.valueOf(!value.equals("0") && !value.equals("false")).toString();
            }
            case FLOAT32: {
                return String.valueOf(value) + "f";
            }
            case STRING: {
                return "\"" + MessageInterfaceBuilder.escapeJava(value) + "\"";
            }
            case INT8: 
            case BYTE: 
            case UINT8: 
            case CHAR: 
            case INT16: 
            case UINT16: 
            case INT32: 
            case UINT32: 
            case INT64: 
            case UINT64: 
            case FLOAT64: {
                return value;
            }
        }
        throw new RosRuntimeException("Unsupported PrimitiveFieldType: " + primitiveFieldType);
    }

    private void appendConstants(MessageContext messageContext, StringBuilder builder) {
        MessageFields messageFields = new MessageFields(messageContext);
        for (Field field : messageFields.getFields()) {
            if (!field.isConstant()) continue;
            Preconditions.checkState((boolean)(field.getType() instanceof PrimitiveFieldType));
            FieldType fieldType = field.getType();
            String value = this.getJavaValue((PrimitiveFieldType)fieldType, field.getValue().toString());
            builder.append(String.format("  static final %s %s = %s;\n", fieldType.getJavaTypeName(), field.getName(), value));
        }
    }

    private void appendSettersAndGetters(MessageContext messageContext, StringBuilder builder) {
        MessageFields messageFields = new MessageFields(messageContext);
        HashSet getters = Sets.newHashSet();
        for (Field field : messageFields.getFields()) {
            if (field.isConstant()) continue;
            String type = field.getJavaTypeName();
            String getter = messageContext.getFieldGetterName(field.getName());
            String setter = messageContext.getFieldSetterName(field.getName());
            if (getters.contains(getter)) continue;
            getters.add(getter);
            builder.append(String.format("  %s %s();\n", type, getter));
            builder.append(String.format("  void %s(%s value);\n", setter, type));
        }
    }
}

