/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ui.composites;

import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.MQTTClient;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.ui.ApogyAddonsMQTTUIFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class MQTTTopicListComposite
extends EMFFormsEListComposite<MQTTClient, MQTTClient, MQTTTopic> {
    private UIJob uiJob;

    public MQTTTopicListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.APOGY_MQTT_REGISTRY__CLIENT_LIST, settings);
        this.getJob().schedule();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MQTTTopicListComposite.this.getJob().cancel();
            }
        });
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Topic Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    return topic.getTopicName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__TOPIC_NAME);
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + topic.getTopicName();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTTopic) {
                    return MQTTTopicListComposite.this.getMQTTTopicBackground((MQTTTopic)element);
                }
                return null;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setText("State");
        stateColumn.getColumn().setAlignment(0x1000000);
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    return topic.getState().getLiteral();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE);
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + topic.getState().getLiteral();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTTopic) {
                    return MQTTTopicListComposite.this.getMQTTTopicBackground((MQTTTopic)element);
                }
                return null;
            }
        });
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn expectedPeriodColumn = new TreeViewerColumn(viewer, 0);
        String displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__EXPECTED_UPDATE_PERIOD).toString();
        expectedPeriodColumn.getColumn().setText("Update Period (" + displayUnits + ")");
        expectedPeriodColumn.getColumn().setAlignment(0x1000000);
        expectedPeriodColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    if (topic.getExpectedUpdatePeriod() > 0L) {
                        return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)topic.getExpectedUpdatePeriod(), (ETypedElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__EXPECTED_UPDATE_PERIOD);
                    }
                    return "N/A";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__EXPECTED_UPDATE_PERIOD);
                if (element instanceof MQTTTopic) {
                    MQTTTopic topic = (MQTTTopic)element;
                    tooltipText = topic.getExpectedUpdatePeriod() > 0L ? String.valueOf(tooltipText) + "\n\n" + ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)topic.getExpectedUpdatePeriod(), (ETypedElement)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__EXPECTED_UPDATE_PERIOD) : String.valueOf(tooltipText) + "\n\nN/A";
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTTopic) {
                    return MQTTTopicListComposite.this.getMQTTTopicBackground((MQTTTopic)element);
                }
                return null;
            }
        });
        expectedPeriodColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return MQTTTopicListComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)object;
                    return client.getSubscribedTopics().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected Color getMQTTTopicBackground(MQTTTopic topic) {
        return ApogyAddonsMQTTUIFacade.INSTANCE.getColot(topic.getState());
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected UIJob getJob() {
        if (this.uiJob == null) {
            this.uiJob = new UIJob("Update"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            MQTTTopicListComposite.this.getViewer().refresh(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.schedule(1000L);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.uiJob;
    }
}

