/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.ApogyMQTTRegistry;
import org.eclipse.apogy.addons.mqtt.MQTTClient;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.ui.ApogyAddonsMQTTUIFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class MQTTClientListComposite
extends EMFFormsEListComposite<ApogyMQTTRegistry, ApogyMQTTRegistry, MQTTClient> {
    private UIJob uiJob;

    public MQTTClientListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.APOGY_MQTT_REGISTRY__CLIENT_LIST, settings);
        this.getJob().schedule();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MQTTClientListComposite.this.getJob().cancel();
            }
        });
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTClient) {
                    MQTTClient topic = (MQTTClient)element;
                    return topic.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = "Name of the Client.";
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + client.getName();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTClient) {
                    return MQTTClientListComposite.this.getMQTTClientBackground((MQTTClient)element);
                }
                return null;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setText("State");
        stateColumn.getColumn().setAlignment(0x1000000);
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    return client.getState().getLiteral();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE);
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + client.getState().getLiteral();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTClient) {
                    return MQTTClientListComposite.this.getMQTTClientBackground((MQTTClient)element);
                }
                return null;
            }
        });
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        TreeViewerColumn serverHostColumn = new TreeViewerColumn(viewer, 0);
        serverHostColumn.getColumn().setText("Broker Host Name");
        serverHostColumn.getColumn().setAlignment(0x1000000);
        serverHostColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    return client.getBrokerHostName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__BROKER_HOST_NAME);
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + client.getName();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTClient) {
                    return MQTTClientListComposite.this.getMQTTClientBackground((MQTTClient)element);
                }
                return null;
            }
        });
        serverHostColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn serverPort = new TreeViewerColumn(viewer, 0);
        serverPort.getColumn().setText("Host Port");
        serverPort.getColumn().setAlignment(0x1000000);
        serverPort.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    return Integer.toString(client.getPort());
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__PORT);
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + client.getPort();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTClient) {
                    return MQTTClientListComposite.this.getMQTTClientBackground((MQTTClient)element);
                }
                return null;
            }
        });
        serverPort.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn clientID = new TreeViewerColumn(viewer, 0);
        clientID.getColumn().setText("Client ID");
        clientID.getColumn().setAlignment(0x1000000);
        clientID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    return client.getClientId();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String tooltipText = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__CLIENT_ID);
                if (element instanceof MQTTClient) {
                    MQTTClient client = (MQTTClient)element;
                    tooltipText = String.valueOf(tooltipText) + "\n\n" + client.getClientId();
                }
                return tooltipText;
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTClient) {
                    return MQTTClientListComposite.this.getMQTTClientBackground((MQTTClient)element);
                }
                return null;
            }
        });
        clientID.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return MQTTClientListComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof ApogyMQTTRegistry) {
                    ApogyMQTTRegistry registry = (ApogyMQTTRegistry)object;
                    return registry.getClientList().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected Color getMQTTClientBackground(MQTTClient client) {
        return ApogyAddonsMQTTUIFacade.INSTANCE.getColor(client.getState());
    }

    protected void createButtons(Composite parent, int style) {
        Button generateTopicListButton = this.createGenerateTopicListButton(parent, style);
        generateTopicListButton.setEnabled(true);
    }

    protected Button createGenerateTopicListButton(Composite parent, int style) {
        Button btnActivate = MQTTClientListComposite.createButton((Composite)parent, (int)0, (String)"Generate Topics List", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doGenerateTopicList(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createActivateButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void createAGenerateTopicListButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> true);
    }

    protected void doGenerateTopicList(List<MQTTClient> list) {
        System.out.println("# Topics");
        for (MQTTClient client : ((ApogyMQTTRegistry)this.getRootEObject()).getClientList()) {
            System.out.println("# " + client.getName());
            for (MQTTTopic topic : client.getSubscribedTopics()) {
                System.out.println(topic.getTopicName());
            }
        }
    }

    protected UIJob getJob() {
        if (this.uiJob == null) {
            this.uiJob = new UIJob("Update"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            MQTTClientListComposite.this.getViewer().refresh(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.schedule(1000L);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.uiJob;
    }
}

