/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.vecmath.Point3f;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.EnvironmentUtilities;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.surface.ui.EnvironmentSurfaceUIUtilities;
import org.eclipse.apogy.core.environment.surface.ui.jme3.Activator;
import org.eclipse.apogy.core.environment.ui.scene_objects.StarFieldSceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarFieldJME3Object
extends DefaultJME3SceneObject<StarField>
implements StarFieldSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(StarFieldJME3Object.class);
    public static final float MAGNITUDE_GROUP_RANGE = 0.5f;
    public static final float MIN_POINT_SIZE = 0.5f;
    public static final float MAX_POINT_SIZE = 4.0f;
    private StarField starField = null;
    private float highestMagnitude = 6.0f;
    private int minMagnitudeLevel = 0;
    private int maxMagnitudeLevel = 10;
    private final SortedMap<Float, Geometry> starsMagnitudeToGeometry = new TreeMap<Float, Geometry>();
    private AssetManager assetManager = this.jme3Application.getAssetManager();

    public StarFieldJME3Object(StarField node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.starField = node;
        Job job = new Job("StarFieldJME3Object : Updating Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                StarFieldJME3Object.this.requestUpdate();
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                float magnitudeCutoff = (float)store.getDouble("DEFAULT_STAR_MAGNITUDE_CUTOFF_ID");
                StarFieldJME3Object.this.setCutOffMagnitude(magnitudeCutoff);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        for (Geometry geometry : this.starsMagnitudeToGeometry.values()) {
            if (geometry == null) continue;
            this.getAttachmentNode().detachChild((Spatial)geometry);
        }
        this.createStars();
        for (Geometry geometry : this.starsMagnitudeToGeometry.values()) {
            if (geometry == null) continue;
            this.getAttachmentNode().attachChild((Spatial)geometry);
        }
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Geometry geometry : this.starsMagnitudeToGeometry.values()) {
            geometries.add(geometry);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.requestUpdate();
    }

    public void setCutOffMagnitude(float cutOffMagnitude) {
        this.highestMagnitude = cutOffMagnitude;
        Logger.info("Setting Cutoff Magnitude to <" + cutOffMagnitude + ">.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SortedMap toSwitchOff = StarFieldJME3Object.this.starsMagnitudeToGeometry.tailMap(new Float(StarFieldJME3Object.this.highestMagnitude));
                for (Geometry s : toSwitchOff.values()) {
                    if (s == null) continue;
                    StarFieldJME3Object.this.getAttachmentNode().detachChild((Spatial)s);
                }
                SortedMap toSwitchOn = StarFieldJME3Object.this.starsMagnitudeToGeometry.headMap(new Float(StarFieldJME3Object.this.highestMagnitude));
                for (Geometry s : toSwitchOn.values()) {
                    if (s == null) continue;
                    StarFieldJME3Object.this.getAttachmentNode().attachChild((Spatial)s);
                }
                return null;
            }
        });
    }

    private void createStars() {
        this.starsMagnitudeToGeometry.clear();
        SortedSet sortedStars = EnvironmentUtilities.INSTANCE.sortByMagnitude((List)this.starField.getStars());
        this.minMagnitudeLevel = (int)Math.floor(((Star)sortedStars.first()).getMagnitude());
        this.maxMagnitudeLevel = (int)Math.ceil(((Star)sortedStars.last()).getMagnitude());
        int numberOfMagnitudeLevels = Math.round((float)(this.maxMagnitudeLevel - this.minMagnitudeLevel) / 0.5f);
        float minMagnitude = this.minMagnitudeLevel;
        ArrayList<Star> starsWithinMagnitude = new ArrayList<Star>();
        int j = 0;
        while (j < numberOfMagnitudeLevels) {
            starsWithinMagnitude.clear();
            for (Star s : sortedStars) {
                if (!(s.getMagnitude() >= minMagnitude) || !(s.getMagnitude() < minMagnitude + 0.5f)) continue;
                starsWithinMagnitude.add(s);
            }
            if (starsWithinMagnitude.size() > 0) {
                Mesh starsGroupMesh = this.getShapeForStars(starsWithinMagnitude, minMagnitude);
                String name = "Stars with " + Float.toString(minMagnitude) + " < Magnitude < " + Float.toString(minMagnitude + 0.5f);
                Geometry starsGroupGeometry = new Geometry(name, starsGroupMesh);
                float alpha = 1.0f - this.transparency;
                Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
                mat.setColor("Color", new ColorRGBA(1.0f, 1.0f, 1.0f, alpha));
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                starsGroupGeometry.setMaterial(mat);
                starsGroupGeometry.setQueueBucket(RenderQueue.Bucket.Transparent);
                this.starsMagnitudeToGeometry.put(new Float(minMagnitude), starsGroupGeometry);
            }
            minMagnitude += 0.5f;
            ++j;
        }
    }

    private Mesh getShapeForStars(List<Star> stars, float magnitude) {
        float pointSize = EnvironmentSurfaceUIUtilities.INSTANCE.getPointSizeForMagnitude(magnitude, (float)this.minMagnitudeLevel, (float)this.maxMagnitudeLevel, 0.5f, 4.0f);
        Vector3f[] vertices = new Vector3f[stars.size()];
        int i = 0;
        while (i < stars.size()) {
            Star star = stars.get(i);
            Point3f p = EnvironmentSurfaceUIUtilities.INSTANCE.toPoint3f(star);
            p.scale(20000.0f);
            vertices[i] = new Vector3f(p.x, p.y, p.z);
            ++i;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Points);
        mesh.setPointSize(pointSize);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }
}

