/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.jme3.Data3dJME3Utilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.apogy.core.environment.surface.ImageBasedShaderBasedMeshTool;
import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshTool;
import org.eclipse.apogy.core.environment.surface.ui.scene_objects.CartesianTriangularMeshMapLayerNodeSceneObject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshMapLayerNodeJM3SceneObject
extends DefaultJME3SceneObject<CartesianTriangularMeshMapLayerNode>
implements CartesianTriangularMeshMapLayerNodeSceneObject {
    private int NUMBER_OF_PARAMETERS = 32;
    private int NUMBER_OF_TOOLS = 8;
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshMapLayerNodeJM3SceneObject.class);
    private boolean useShading = true;
    private boolean updatingGeometry = false;
    private RGBA rgb = this.getDefaultColor();
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.SURFACE;
    private AbstractEImage textureImage = null;
    private Adapter layerAdapter = null;
    private Adapter pointsAdapter = null;
    private Adapter polygonsAdapter = null;
    private Collection<ShaderBasedMeshTool> shaderBasedMeshToolList = new ArrayList<ShaderBasedMeshTool>();
    private Adapter shaderBasedMeshToolsAdapter;
    private Point3d centroid = null;
    private CartesianTriangularMesh mesh = null;
    private AssetManager assetManager;
    private Geometry meshGeometry = null;
    private Mesh jme3mMesh = null;
    private final AWTLoader awtLoader = new AWTLoader();

    public CartesianTriangularMeshMapLayerNodeJM3SceneObject(CartesianTriangularMeshMapLayerNode cartesianTriangularMeshMapLayerNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)cartesianTriangularMeshMapLayerNode, jme3RenderEngineDelegate);
        if (cartesianTriangularMeshMapLayerNode == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.mesh = cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().getCurrentMesh();
        this.textureImage = cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().getTextureImage();
        try {
            String urlString = "platform:plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(CartesianTriangularMeshMapLayerNodeJM3SceneObject.class) + "/assets";
            URL url = FileLocator.toFileURL((URL)new URL(urlString));
            this.assetManager.registerLocator(url.getPath(), com.jme3.asset.plugins.FileLocator.class);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        Job job = new Job("CartesianTriangularMeshMapLayerNode : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                final Mesh newMesh = Data3dJME3Utilities.createMesh((CartesianTriangularMesh)CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh);
                CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.updateGeometryInternal(newMesh);
                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.setPresentationMode(CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshPresentationMode);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        for (ShaderBasedMeshTool tool : cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().getShaderBasedMeshTools()) {
            this.addShaderBasedMeshTool(tool);
        }
        cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().eAdapters().add((Object)this.getLayerAdapter());
        this.mesh.eAdapters().add((Object)this.getPointsAdapter());
        this.mesh.eAdapters().add((Object)this.getPolygonsAdapter());
        cartesianTriangularMeshMapLayerNode.getCartesianTriangularMeshMapLayer().eAdapters().add((Object)this.getShaderBasedMeshToolsAdapter());
    }

    public void updateGeometry(float tpf) {
        Mesh newMesh = Data3dJME3Utilities.createMesh((CartesianTriangularMesh)this.mesh);
        this.updateGeometryInternal(newMesh);
    }

    public Point3d getCentroid() {
        if (this.centroid == null) {
            this.centroid = new Point3d(0.0, 0.0, 0.0);
            if (this.mesh != null && this.mesh.getPoints().size() > 0) {
                for (CartesianPositionCoordinates point : this.mesh.getPoints()) {
                    this.centroid.x += point.getX();
                    this.centroid.y += point.getY();
                    this.centroid.z += point.getZ();
                }
                this.centroid.scale(1.0 / (double)this.mesh.getPoints().size());
            }
        }
        return this.centroid;
    }

    public void setColor(RGBA rgb) {
        Logger.info("Setting color to <" + rgb + ">.");
        this.rgb = rgb;
        if (rgb != null) {
            final ColorRGBA meshColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry != null) {
                        Material mat = CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.createMaterial();
                        if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.useShading) {
                            mat.setColor("Diffuse", meshColor);
                            mat.setColor("Ambient", meshColor);
                            mat.setColor("Specular", meshColor);
                        } else {
                            mat.setColor("Color", meshColor);
                        }
                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.setMaterial(mat);
                    }
                    return null;
                }
            });
        }
    }

    public RGBA getColor() {
        if (this.rgb == null) {
            this.rgb = new RGBA(255, 255, 255, 255);
        }
        return this.rgb;
    }

    protected ColorRGBA getColorRGBA() {
        return JME3Utilities.convertToColorRGBA((RGBA)this.getColor());
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.meshGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).eAdapters().remove((Object)this.getLayerAdapter());
            ((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).eAdapters().remove((Object)this.getShaderBasedMeshToolsAdapter());
        }
        if (this.mesh != null) {
            this.mesh.eAdapters().remove((Object)this.getPointsAdapter());
            this.mesh.eAdapters().remove((Object)this.getPolygonsAdapter());
        }
        for (ShaderBasedMeshTool tool : this.shaderBasedMeshToolList) {
            tool.eAdapters().remove((Object)this.getShaderBasedMeshToolsAdapter());
        }
        this.textureImage = null;
        super.dispose();
    }

    public void setPresentationMode(MeshPresentationMode mode) {
        Logger.info("Setting presentation mode to " + mode);
        this.meshPresentationMode = mode;
        if (this.meshGeometry != null && this.meshGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    switch (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshPresentationMode.getValue()) {
                        case 1: {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 2: {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                            if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 0: {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Points);
                            break;
                        }
                    }
                    return null;
                }
            });
        } else {
            Logger.warn("Failed to set presentation mode to " + mode);
        }
    }

    public void setPointSize(final int pointSize) {
        Logger.info("Setting point size to " + pointSize);
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.jme3mMesh.setPointSize((float)pointSize);
                    return null;
                }
            });
        }
    }

    public void setUseShading(final boolean useShading) {
        Logger.info("Setting use shading to " + useShading);
        this.useShading = useShading;
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Material mat = CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.createMaterial();
                    ColorRGBA color = CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.getColorRGBA();
                    if (useShading) {
                        mat.setColor("Diffuse", color);
                        mat.setColor("Ambient", color);
                        mat.setColor("Specular", color);
                    } else {
                        mat.setColor("Color", color);
                    }
                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.setMaterial(mat);
                    return null;
                }
            });
        }
    }

    public void applyTextureImage(AbstractEImage abstractEImage) {
        this.textureImage = abstractEImage;
        this.requestUpdate();
    }

    private void updateGeometryInternal(Mesh newMesh) {
        try {
            if (!this.updatingGeometry) {
                this.updatingGeometry = true;
                this.centroid = null;
                if (this.meshGeometry != null) {
                    this.getAttachmentNode().detachChild((Spatial)this.meshGeometry);
                }
                this.jme3mMesh = newMesh;
                if (this.jme3mMesh != null) {
                    this.meshGeometry = ((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).getNodeId() != null ? new Geometry(((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("CartesianTriangularMesh", this.jme3mMesh);
                    this.meshGeometry.setMaterial(this.createMaterial());
                    this.meshGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    this.getAttachmentNode().attachChild((Spatial)this.meshGeometry);
                }
                this.updatingGeometry = false;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Material createMaterial() {
        Material mat = null;
        ColorRGBA color = this.getColorRGBA();
        if (this.useShading) {
            mat = new Material(this.assetManager, "MatDefs/TerrainLighting.j3md");
            if (color != null) {
                mat.setColor("Diffuse", color);
                mat.setColor("Ambient", color);
                mat.setColor("Specular", color);
            }
            mat.setFloat("Shininess", 64.0f);
            mat.setBoolean("UseMaterialColors", true);
            int i = 0;
            while (i < this.NUMBER_OF_TOOLS) {
                Matrix4f m = this.createMatrix4f(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
                mat.setMatrix4(this.getToolMatrixNameForIndex(i), m);
                mat.setTexture(this.getToolTextureNameForIndex(i), null);
                float[] parameters = new float[this.NUMBER_OF_PARAMETERS];
                mat.setParam(this.getToolParamNameForIndex(i), VarType.FloatArray, (Object)parameters);
                ++i;
            }
            if (this.textureImage != null) {
                Texture2D texture = this.createTexture(this.textureImage);
                mat.setTexture("DiffuseMap", (Texture)texture);
            }
            this.updateAllShaders(mat);
        } else {
            mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            if (color != null) {
                mat.setColor("Color", color);
            }
            if (this.textureImage != null && this.textureImage.getHeight() > 0 && this.textureImage.getWidth() > 0) {
                Texture2D texture = this.createTexture(this.textureImage);
                mat.setTexture("ColorMap", (Texture)texture);
            }
        }
        return mat;
    }

    private void addShaderBasedMeshTool(ShaderBasedMeshTool tool) {
        this.shaderBasedMeshToolList.add(tool);
        tool.eAdapters().add((Object)this.getShaderBasedMeshToolsAdapter());
        try {
            tool.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeShaderBasedMeshTool(ShaderBasedMeshTool tool) {
        this.shaderBasedMeshToolList.remove(tool);
        tool.eAdapters().remove((Object)this.getShaderBasedMeshToolsAdapter());
    }

    private void updateAllShaders(Material mat) {
        if (mat != null) {
            int toolIndex = 0;
            for (ShaderBasedMeshTool tool : ((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).getCartesianTriangularMeshMapLayer().getShaderBasedMeshTools()) {
                ImageBasedShaderBasedMeshTool t;
                AbstractEImage image;
                Matrix4f m = this.createMatrix4f(tool.createToolMatrix());
                mat.setParam(this.getToolMatrixNameForIndex(toolIndex), VarType.Matrix4, (Object)m);
                if (tool instanceof ImageBasedShaderBasedMeshTool && (image = (t = (ImageBasedShaderBasedMeshTool)tool).getImage()) != null) {
                    Texture2D texture = this.createTexture(image);
                    mat.setTexture(this.getToolTextureNameForIndex(toolIndex), (Texture)texture);
                }
                float[] parameters = tool.createShaderParameters();
                mat.setParam(this.getToolParamNameForIndex(toolIndex), VarType.FloatArray, (Object)parameters);
                ++toolIndex;
            }
            int i = toolIndex;
            while (i < this.NUMBER_OF_TOOLS) {
                Matrix4f m = this.createMatrix4f(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
                mat.setParam(this.getToolMatrixNameForIndex(toolIndex), VarType.Matrix4, (Object)m);
                mat.setParam(this.getToolParamNameForIndex(toolIndex), VarType.FloatArray, (Object)new float[this.NUMBER_OF_PARAMETERS]);
                mat.setTexture(this.getToolTextureNameForIndex(i), null);
                ++i;
            }
        }
    }

    private void updateShaderBasedMeshTool(Material mat, ShaderBasedMeshTool tool) {
        int toolIndex = ((CartesianTriangularMeshMapLayerNode)this.getTopologyNode()).getCartesianTriangularMeshMapLayer().getShaderBasedMeshTools().indexOf((Object)tool);
        if (toolIndex >= 0) {
            ImageBasedShaderBasedMeshTool t;
            AbstractEImage image;
            Matrix4f m = this.createMatrix4f(tool.createToolMatrix());
            mat.setParam(this.getToolMatrixNameForIndex(toolIndex), VarType.Matrix4, (Object)m);
            if (tool instanceof ImageBasedShaderBasedMeshTool && (image = (t = (ImageBasedShaderBasedMeshTool)tool).getImage()) != null) {
                Texture2D texture = this.createTexture(image);
                mat.setTexture(this.getToolTextureNameForIndex(toolIndex), (Texture)texture);
            }
            float[] parameters = tool.createShaderParameters();
            mat.setParam(this.getToolParamNameForIndex(toolIndex), VarType.FloatArray, (Object)parameters);
        }
    }

    private String getToolMatrixNameForIndex(int toolIndex) {
        return "Tool" + toolIndex + "Matrix";
    }

    private String getToolTextureNameForIndex(int toolIndex) {
        return "Tool" + toolIndex + "Texture2D";
    }

    private String getToolParamNameForIndex(int toolIndex) {
        return "Tool" + toolIndex;
    }

    private Matrix4f createMatrix4f(Matrix4x4 matrix) {
        float[] data = new float[]{new Float(matrix.getM00()).floatValue(), new Float(matrix.getM10()).floatValue(), new Float(matrix.getM20()).floatValue(), new Float(matrix.getM30()).floatValue(), new Float(matrix.getM01()).floatValue(), new Float(matrix.getM11()).floatValue(), new Float(matrix.getM21()).floatValue(), new Float(matrix.getM31()).floatValue(), new Float(matrix.getM02()).floatValue(), new Float(matrix.getM12()).floatValue(), new Float(matrix.getM22()).floatValue(), new Float(matrix.getM32()).floatValue(), new Float(matrix.getM03()).floatValue(), new Float(matrix.getM13()).floatValue(), new Float(matrix.getM23()).floatValue(), new Float(matrix.getM33()).floatValue()};
        Matrix4f m = new Matrix4f(data);
        return m;
    }

    private Texture2D createTexture(AbstractEImage textureImage) {
        int width = textureImage.getWidth();
        int height = textureImage.getHeight();
        RGBA rgba = this.getColor();
        AbstractEImage background = EImagesUtilities.INSTANCE.createUniformColorImage(width, height, rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, 255);
        AbstractEImage newImage = EImagesUtilities.INSTANCE.applyOverlay(background, textureImage, false);
        Image img = this.awtLoader.load(newImage.asBufferedImage(), true);
        Texture2D texture = new Texture2D(img);
        return texture;
    }

    private RGBA getDefaultColor() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_TRIANGULAR_MESH_COLOR_ID");
        if (rgb == null) {
            rgb = new RGB(255, 255, 255);
        }
        return ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb);
    }

    private Adapter getPointsAdapter() {
        if (this.pointsAdapter == null) {
            this.pointsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 0) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.pointsAdapter;
    }

    private Adapter getPolygonsAdapter() {
        if (this.polygonsAdapter == null) {
            this.polygonsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 2) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.polygonsAdapter;
    }

    private Adapter getLayerAdapter() {
        if (this.layerAdapter == null) {
            this.layerAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof CartesianTriangularMeshMapLayer) {
                        CartesianTriangularMeshMapLayer cartesianTriangularMeshMapLayer = (CartesianTriangularMeshMapLayer)msg.getNotifier();
                        int featureId = msg.getFeatureID(CartesianTriangularMeshMapLayer.class);
                        switch (featureId) {
                            case 4: {
                                try {
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh.eAdapters().remove((Object)CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.getPointsAdapter());
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh.eAdapters().remove((Object)CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.getPolygonsAdapter());
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh = cartesianTriangularMeshMapLayer.getCurrentMesh();
                                    if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh != null) {
                                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh.eAdapters().add((Object)CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.getPointsAdapter());
                                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.mesh.eAdapters().add((Object)CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.getPolygonsAdapter());
                                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.requestUpdate();
                                        break;
                                    }
                                    Logger.warn("Mesh is null !");
                                }
                                catch (Throwable t) {
                                    Logger.debug(t.getMessage(), t);
                                }
                                break;
                            }
                            case 6: {
                                try {
                                    AbstractEImage newTextureImage = (AbstractEImage)msg.getNewValue();
                                    Logger.info("Updating mesh texture.");
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.applyTextureImage(newTextureImage);
                                    break;
                                }
                                catch (Throwable t) {
                                    Logger.error(t.getMessage(), t);
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.layerAdapter;
    }

    protected Adapter getShaderBasedMeshToolsAdapter() {
        if (this.shaderBasedMeshToolsAdapter == null) {
            this.shaderBasedMeshToolsAdapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    block15: {
                        block14: {
                            super.notifyChanged(msg);
                            if (!(msg.getNotifier() instanceof CartesianTriangularMeshMapLayer)) break block14;
                            int featureId = msg.getFeatureID(CartesianTriangularMeshMapLayer.class);
                            if (featureId != 8) break block15;
                            switch (msg.getEventType()) {
                                case 3: {
                                    ShaderBasedMeshTool tool = (ShaderBasedMeshTool)msg.getNewValue();
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.addShaderBasedMeshTool(tool);
                                    break;
                                }
                                case 5: {
                                    Collection tools = (Collection)msg.getNewValue();
                                    for (ShaderBasedMeshTool tool : tools) {
                                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.addShaderBasedMeshTool(tool);
                                    }
                                    break;
                                }
                                case 4: {
                                    ShaderBasedMeshTool tool = (ShaderBasedMeshTool)msg.getOldValue();
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.removeShaderBasedMeshTool(tool);
                                    break;
                                }
                                case 6: {
                                    Collection tools = (Collection)msg.getOldValue();
                                    for (ShaderBasedMeshTool tool : tools) {
                                        CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.removeShaderBasedMeshTool(tool);
                                    }
                                    break;
                                }
                            }
                            if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry == null) break block15;
                            CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.updateAllShaders(CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial());
                            break block15;
                        }
                        if (msg.getNotifier() instanceof ShaderBasedMeshTool) {
                            if (CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry != null) {
                                ShaderBasedMeshTool tool = (ShaderBasedMeshTool)msg.getNotifier();
                                CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.updateShaderBasedMeshTool(CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial(), tool);
                            }
                        } else if (msg.getNotifier() instanceof EObject) {
                            EObject notifier = (EObject)msg.getNotifier();
                            EObject parent = notifier.eContainer();
                            while (parent != null) {
                                if (parent instanceof ShaderBasedMeshTool) {
                                    ShaderBasedMeshTool tool = (ShaderBasedMeshTool)parent;
                                    CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.updateShaderBasedMeshTool(CartesianTriangularMeshMapLayerNodeJM3SceneObject.this.meshGeometry.getMaterial(), tool);
                                    return;
                                }
                                parent = parent.eContainer();
                            }
                        }
                    }
                }
            };
        }
        return this.shaderBasedMeshToolsAdapter;
    }
}

