/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.emf.AbstractFeatureListNode;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ListFeatureNode;
import org.eclipse.apogy.common.emf.ListRootNode;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ReferencedGroupNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsFactory;
import org.eclipse.apogy.common.topology.bindings.TransformMatrixBinding;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.TypeMemberImplementation;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.apogy.core.topology.impl.ApogySystemAPIsNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystemAPIsNodeCustomImpl
extends ApogySystemAPIsNodeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystemAPIsNodeImpl.class);
    private final List<AssemblyLink> processedAssemblyLink = new ArrayList<AssemblyLink>();
    private Map<Context, Map<Variable, Node>> contextToVariableToNodeMap = new HashMap<Context, Map<Variable, Node>>();
    private Adapter adapter = null;

    @Override
    public void setApogyEnvironment(ApogyEnvironment newApogyEnvironment) {
        ApogyEnvironment oldApogyEnvironment = this.getApogyEnvironment();
        super.setApogyEnvironment(newApogyEnvironment);
        this.updateApogyEnvironment(oldApogyEnvironment, newApogyEnvironment);
    }

    private void clearTopology() {
        this.getChildren().clear();
    }

    private void updateApogyEnvironment(ApogyEnvironment oldApogyEnvironment, ApogyEnvironment newApogyEnvironment) {
        this.clearTopology();
        this.contextToVariableToNodeMap.clear();
        if (oldApogyEnvironment != null) {
            oldApogyEnvironment.eAdapters().remove((Object)this.getAdapter());
            if (oldApogyEnvironment.getActiveContext() != null) {
                oldApogyEnvironment.getActiveContext().eAdapters().remove((Object)this.getAdapter());
            }
        }
        if (newApogyEnvironment != null) {
            newApogyEnvironment.eAdapters().add((Object)this.getAdapter());
            if (newApogyEnvironment.getActiveContext() != null) {
                newApogyEnvironment.getActiveContext().eAdapters().add((Object)this.getAdapter());
            }
            this.initializeTopology(newApogyEnvironment);
        }
    }

    private void updateContext(Context oldContext, Context newContext) {
        Map<Variable, Node> newContextMap;
        Node node;
        EList nodes;
        GroupNode root;
        String nodeName;
        Variable variable;
        if (oldContext != null) {
            Map<Variable, Node> oldContextMap = this.contextToVariableToNodeMap.get(oldContext);
            if (oldContextMap == null) {
                oldContextMap = new HashMap<Variable, Node>();
                this.contextToVariableToNodeMap.put(oldContext, oldContextMap);
            }
            for (VariableImplementation impl : oldContext.getVariableImplementationsList().getVariableImplementations()) {
                variable = impl.getVariable();
                nodeName = String.valueOf(variable.getName()) + "_poseTransform";
                nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeName, (Node)(root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode()));
                if (nodes.isEmpty()) continue;
                node = (Node)nodes.get(0);
                oldContextMap.put(variable, node);
                this.getChildren().remove((Object)node);
            }
        }
        if ((newContextMap = this.contextToVariableToNodeMap.get(newContext)) != null) {
            for (VariableImplementation impl : newContext.getVariableImplementationsList().getVariableImplementations()) {
                variable = impl.getVariable();
                Node root2 = newContextMap.get(variable);
                if (root2 == null) continue;
                this.getChildren().add((Object)root2);
            }
        } else {
            this.initializeTopology(this.getApogyEnvironment());
            newContextMap = new HashMap<Variable, Node>();
            this.contextToVariableToNodeMap.put(newContext, newContextMap);
            for (VariableImplementation impl : oldContext.getVariableImplementationsList().getVariableImplementations()) {
                variable = impl.getVariable();
                nodeName = String.valueOf(variable.getName()) + "_poseTransform";
                nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeName, (Node)(root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode()));
                if (nodes.isEmpty()) continue;
                node = (Node)nodes.get(0);
                newContextMap.put(variable, node);
            }
        }
        if (oldContext != null) {
            oldContext.eAdapters().remove((Object)this.getAdapter());
        }
        if (newContext != null) {
            newContext.eAdapters().add((Object)this.getAdapter());
        }
    }

    private void updateVariablesImplementations() {
        this.clearTopology();
        this.contextToVariableToNodeMap.clear();
        this.initializeTopology(this.getApogyEnvironment());
    }

    private TransformMatrixBinding createTransformMatrixBinding(ApogySystem apogySystem, TransformNode poseTransform, PoseProvider poseProvider) {
        TransformMatrixBinding binding = ApogyCommonTopologyBindingsFactory.eINSTANCE.createTransformMatrixBinding();
        ListRootNode listRootNode = ApogyCommonEMFFactory.eINSTANCE.createListRootNode();
        listRootNode.setSourceClass(poseProvider.eClass());
        ListFeatureNode listFeatureNode = ApogyCommonEMFFactory.eINSTANCE.createListFeatureNode();
        listFeatureNode.setStructuralFeature((EStructuralFeature)ApogyCorePackage.Literals.POSE_PROVIDER__POSE_TRANSFORM);
        listRootNode.setChild((AbstractFeatureListNode)listFeatureNode);
        binding.setFeatureNode((AbstractFeatureNode)listFeatureNode);
        binding.setTransformNode(poseTransform);
        binding.setSource((EObject)poseProvider);
        apogySystem.getBindingSet().getBindingsList().getBindings().add((Object)binding);
        binding.bind();
        return binding;
    }

    private Map<ApogySystem, ApogySystemApiAdapter> createSystemToApiAdapterMap(ApogyEnvironment apogyEnvironment) {
        HashMap<ApogySystem, ApogySystemApiAdapter> map = new HashMap<ApogySystem, ApogySystemApiAdapter>();
        Iterator it = apogyEnvironment.getActiveContext().getVariableImplementationsList().getVariableImplementations().iterator();
        VariableImplementation variableImplementation = null;
        while (it.hasNext()) {
            variableImplementation = (VariableImplementation)it.next();
            this.createSystemToApiAdapterMap((AbstractTypeImplementation)variableImplementation, map);
        }
        return map;
    }

    private void createSystemToApiAdapterMap(AbstractTypeImplementation abstractTypeImplementation, Map<ApogySystem, ApogySystemApiAdapter> systemToApiAdapterMap) {
        ApogySystemApiAdapter apogySystemApiAdapter;
        if (abstractTypeImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter && (apogySystemApiAdapter = (ApogySystemApiAdapter)abstractTypeImplementation.getAdapterInstance()).getApogySystem() != null) {
            ApogySystem apogySystem = apogySystemApiAdapter.getApogySystem();
            systemToApiAdapterMap.put(apogySystem, apogySystemApiAdapter);
        }
        if (abstractTypeImplementation instanceof AbstractTypeImplementation) {
            AbstractTypeImplementation typeMemberImplementationsListProvider = abstractTypeImplementation;
            for (TypeMemberImplementation tmi : typeMemberImplementationsListProvider.getTypeMemberImplementations()) {
                this.createSystemToApiAdapterMap((AbstractTypeImplementation)tmi, systemToApiAdapterMap);
            }
        }
    }

    private void initializeTopology(ApogyEnvironment apogyEnvironment) {
        this.processedAssemblyLink.clear();
        if (apogyEnvironment != null && apogyEnvironment.getActiveContext() != null) {
            Iterator it = apogyEnvironment.getActiveContext().getVariableImplementationsList().getVariableImplementations().iterator();
            VariableImplementation variableImplementation = null;
            Map<ApogySystem, ApogySystemApiAdapter> systemToApiAdapterMap = this.createSystemToApiAdapterMap(apogyEnvironment);
            while (it.hasNext()) {
                variableImplementation = (VariableImplementation)it.next();
                Variable variable = variableImplementation.getVariable();
                try {
                    if (!(variableImplementation.getAdapterInstance() instanceof ApogySystemApiAdapter)) continue;
                    Logger.info("Adding variable <" + variable.getName() + "> to the topology.");
                    ApogySystemApiAdapter apogySystemApiAdapter = (ApogySystemApiAdapter)variableImplementation.getAdapterInstance();
                    ApogySystem apogySystem = apogySystemApiAdapter.getApogySystem();
                    if (apogySystem != null) {
                        ApogySystemApiAdapter poseProvider;
                        Matrix4d matrix = new Matrix4d();
                        matrix.setIdentity();
                        if (apogySystemApiAdapter instanceof PoseProvider && (poseProvider = apogySystemApiAdapter).getPoseTransform() != null) {
                            matrix = poseProvider.getPoseTransform().asMatrix4d();
                        }
                        TransformNode poseTransform = ApogyCommonTopologyFacade.INSTANCE.createTransformNode(matrix);
                        poseTransform.setNodeId(String.valueOf(variable.getName()) + "_poseTransform");
                        if (apogySystem.getPoseProviderInstance() instanceof PoseProvider) {
                            PoseProvider poseProvide = apogySystem.getPoseProviderInstance();
                            this.createTransformMatrixBinding(apogySystem, poseTransform, poseProvide);
                        }
                        poseTransform.setDescription("Created : " + System.currentTimeMillis());
                        ReferencedGroupNode referencedGroupNode = ApogyCommonTopologyFactory.eINSTANCE.createReferencedGroupNode();
                        referencedGroupNode.setNodeId(variableImplementation.getVariable().getName());
                        if (apogySystem.getTopologyRoot() != null && apogySystem.getTopologyRoot().getOriginNode() != null) {
                            referencedGroupNode.getChildren().add((Object)apogySystem.getTopologyRoot().getOriginNode());
                        } else {
                            Logger.info("Variable <" + variable.getName() + "> as no topology attached.");
                            if (apogySystem.getTopologyRoot() != null) {
                                apogySystem.getTopologyRoot().setOriginNode((Node)ApogyCommonTopologyFactory.eINSTANCE.createTransformNode());
                            }
                        }
                        poseTransform.getChildren().add((Object)referencedGroupNode);
                        this.getChildren().add((Object)poseTransform);
                        this.assembleSubSystems(apogySystem, systemToApiAdapterMap);
                        continue;
                    }
                    if (variable.getVariableType().getInterfaceClass() == null) continue;
                    Logger.error("Variable <" + variable.getName() + "> instance's ApogySystem is not initialized.");
                }
                catch (Throwable t) {
                    Logger.error("Failed to create topology for variable <" + variable.getName() + ">", t);
                }
            }
        }
    }

    private void assembleSubSystems(ApogySystem apogySystem, Map<ApogySystem, ApogySystemApiAdapter> systemToApiAdapterMap) {
        Logger.info("Assembling Sub-System <" + apogySystem + ">");
        if (apogySystem.getTopologyRoot() != null && apogySystem.getTopologyRoot().getOriginNode() instanceof GroupNode && apogySystem.getAssemblyLinksList() != null && apogySystem.getAssemblyLinksList().getAssemblyLinks() != null) {
            for (AssemblyLink link : apogySystem.getAssemblyLinksList().getAssemblyLinks()) {
                if (this.processedAssemblyLink.contains(link)) continue;
                Logger.debug("Processing link <" + link.getName() + ">.");
                try {
                    ApogySystem parent = link.getParentInstance();
                    ApogySystem subSystem = link.getSubSystemInstance();
                    if (subSystem != null && parent != null) {
                        Matrix4d transform = null;
                        if (link.getTransformationMatrix() != null) {
                            transform = link.getTransformationMatrix().asMatrix4d();
                        }
                        if (transform == null) {
                            transform = new Matrix4d();
                            transform.setIdentity();
                        }
                        TransformNode linkTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNode(transform);
                        String linkId = null;
                        linkId = link.getName() != null || link.getName().length() > 0 ? "LINK_" + link.getName() : "LINK_TO_" + link.getSubSystemTypeMember().getName();
                        linkId = link.getSubSystemTypeMember().getName();
                        int index = linkId.lastIndexOf("_COPY");
                        if (index > 0) {
                            linkId = linkId.substring(0, index);
                        }
                        linkTransformNode.setNodeId(linkId);
                        linkTransformNode.setDescription("Transform representing link <" + link.getName() + ">");
                        GroupNode parentNode = link.getParentConnectionPoint().getNode();
                        parentNode.getChildren().add((Object)linkTransformNode);
                        Matrix4x4 matrix = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
                        TransformNode poseTransform = ApogyCommonTopologyFacade.INSTANCE.createTransformNode(matrix.asMatrix4d());
                        poseTransform.setNodeId(String.valueOf(subSystem.getName()) + "_poseTransform");
                        poseTransform.setDescription("Transform used to specify the pose of sub-system <" + subSystem.getName() + ">");
                        ReferencedGroupNode referencedGroupNode = ApogyCommonTopologyFactory.eINSTANCE.createReferencedGroupNode();
                        referencedGroupNode.setNodeId("ROOT_OF_" + subSystem.getName());
                        referencedGroupNode.setDescription("Reference to the root of sub-system <" + subSystem.getName() + ">.");
                        if (subSystem.getTopologyRoot() != null && subSystem.getTopologyRoot().getOriginNode() != null) {
                            referencedGroupNode.getChildren().add((Object)subSystem.getTopologyRoot().getOriginNode());
                        }
                        poseTransform.getChildren().add((Object)referencedGroupNode);
                        linkTransformNode.getChildren().add((Object)poseTransform);
                        if (link.getGeometryNode() != null) {
                            if (link.getGeometryNode().getNodeId() == null || link.getGeometryNode().getNodeId().length() == 0) {
                                String linkGeometryID = "LINK_" + link.getName() + "_GEOMETRY";
                                link.getGeometryNode().setNodeId(linkGeometryID);
                            }
                            parentNode.getChildren().add((Object)link.getGeometryNode());
                        }
                        this.processedAssemblyLink.add(link);
                        this.assembleSubSystems(subSystem, systemToApiAdapterMap);
                        continue;
                    }
                    Logger.error("Error occured when processing AssemblyLink <" + link.getName() + "> !");
                }
                catch (Throwable t) {
                    Logger.error("Error occured when processing AssemblyLink <" + link.getName() + "> !", t);
                }
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof Environment) {
                        if (msg.getFeatureID(Environment.class) == 6) {
                            Context oldContext = (Context)msg.getOldValue();
                            Context newContext = (Context)msg.getNewValue();
                            ApogySystemAPIsNodeCustomImpl.this.updateContext(oldContext, newContext);
                        }
                    } else if (msg.getNotifier() instanceof Context) {
                        if (msg.getFeatureID(Context.class) == 6) {
                            ApogySystemAPIsNodeCustomImpl.this.updateVariablesImplementations();
                        } else if (msg.getFeatureID(Context.class) == 7 && msg.getNewValue() != null) {
                            ApogySystemAPIsNodeCustomImpl.this.clearTopology();
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

