/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import org.eclipse.apogy.addons.monitoring.ui.ValueSourceDisplay;
import org.eclipse.apogy.addons.monitoring.ui.ValueSourceDisplayList;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ValueSourceDisplayOutputComposite
extends AbstractEObjectComposite<ValueSourceDisplayList, ValueSourceDisplayList, ValueSourceDisplayList> {
    private Adapter valueSourceDisplayListAdapter;
    private Composite displaysComposite;
    private int numberOfColumns = 1;

    public ValueSourceDisplayOutputComposite(Composite parent, int style, EObjectCompositeSettings settings) {
        super(parent, style, null, null, settings);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        this.displaysComposite = new Composite(parent, 2048);
        this.displaysComposite.setLayout((Layout)new GridLayout(this.numberOfColumns, true));
        this.displaysComposite.layout();
        return this.displaysComposite;
    }

    protected void rootEObjectChanged(ValueSourceDisplayList rootEObject) {
        this.updateDisplays();
    }

    public void setRootEObject(ValueSourceDisplayList rootEObject) {
        if (this.getRootEObject() != null) {
            ((ValueSourceDisplayList)this.getRootEObject()).eAdapters().remove((Object)this.getValueSourceDisplayListAdapter());
        }
        super.setRootEObject((EObject)rootEObject);
        if (rootEObject != null) {
            rootEObject.eAdapters().add((Object)this.getValueSourceDisplayListAdapter());
        }
        this.updateDisplays();
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns > 0) {
            this.numberOfColumns = numberOfColumns;
            this.updateDisplays();
        }
    }

    protected Adapter getValueSourceDisplayListAdapter() {
        if (this.valueSourceDisplayListAdapter == null) {
            this.valueSourceDisplayListAdapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof ValueSourceDisplayList) {
                        int featureID = msg.getFeatureID(ValueSourceDisplayList.class);
                        if (featureID == 1) {
                            ValueSourceDisplayOutputComposite.this.updateDisplays();
                        }
                    } else if (msg.getNotifier() instanceof ValueSourceDisplay) {
                        int featureID = msg.getFeatureID(ValueSourceDisplay.class);
                        switch (featureID) {
                            case 2: 
                            case 3: {
                                ValueSourceDisplayOutputComposite.this.updateDisplays();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.valueSourceDisplayListAdapter;
    }

    protected void updateDisplays() {
        if (this.displaysComposite != null && !this.displaysComposite.isDisposed()) {
            Control[] controlArray = this.displaysComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (!control.isDisposed()) {
                    control.dispose();
                }
                ++n2;
            }
            this.displaysComposite.setLayout((Layout)new GridLayout(this.numberOfColumns, true));
            if (this.getRootEObject() != null && ((ValueSourceDisplayList)this.getRootEObject()).getDisplays() != null) {
                for (ValueSourceDisplay display : ((ValueSourceDisplayList)this.getRootEObject()).getDisplays()) {
                    try {
                        if (!display.isVisible()) continue;
                        if (display.getValueSource() != null) {
                            display.initialise(this.displaysComposite, 2048);
                            Composite displayComposite = display.getComposite();
                            displayComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                            continue;
                        }
                        Label label = new Label(this.displaysComposite, 0);
                        label.setText(String.valueOf(display.getName()) + " - No Value Source set for this display !");
                        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.displaysComposite.pack();
            this.displaysComposite.layout();
        }
    }
}

