/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.net.URL;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFactory;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.SoundNotificationEffect;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.ui.dialogs.URLDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundURLComposite<RootEObject extends SoundNotificationEffect, ResolvedEObject extends SoundNotificationEffect>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, String> {
    private static final Logger Logger = LoggerFactory.getLogger(SoundURLComposite.class);
    private Text urlText;
    private Button selectButton;
    private Button testButton;

    public SoundURLComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        try {
            Composite top = new Composite(parent, 64);
            top.setLayout((Layout)new GridLayout(3, false));
            this.urlText = new Text(top, 2048);
            GridData gridData = new GridData(16384, 0x1000000, true, false);
            gridData.minimumWidth = 400;
            gridData.widthHint = 400;
            this.urlText.setLayoutData((Object)gridData);
            this.selectButton = new Button(top, 8);
            this.selectButton.setText("Select...");
            this.selectButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    URLDialog dialog = new URLDialog(SoundURLComposite.this.selectButton.getShell(), "Select sound URL:"){

                        protected String[] getFileExtensions() {
                            return new String[]{"*.wav"};
                        }
                    };
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet(SoundURLComposite.this.getRootEObject(), (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.SOUND_NOTIFICATION_EFFECT__SOUND_URL, (Object)dialog.getSelectedURL(), true);
                        }
                        catch (Exception e) {
                            Logger.error("Failed to set sound URL!", (Throwable)e);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.testButton = new Button(top, 8);
            this.testButton.setText("Test");
            this.testButton.setToolTipText("Plays the sound file located at the specified URL.");
            this.testButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    try {
                        new URL(((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).getSoundURL());
                        SoundNotificationEffect tmpEffect = SoundURLComposite.this.testSound(((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).getSoundURL(), ((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).getVolume(), ((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).isRepeat());
                        String message = "Playing sound file <" + ((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).getSoundURL() + "> .";
                        MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Play Sound", null, message, 2, new String[]{"STOP"}, 0);
                        dialog.open();
                        tmpEffect.deactivate();
                    }
                    catch (Exception exception) {
                        String message = "Failed to play sound file <" + ((SoundNotificationEffect)SoundURLComposite.this.getRootEObject()).getSoundURL() + ">!";
                        MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Play Sound", null, message, 1, new String[]{"OK"}, 0);
                        dialog.open();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            return top;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
        if (this.urlText != null && !this.urlText.isDisposed()) {
            if (rootEObject != null) {
                this.urlText.setText(rootEObject.getSoundURL());
                this.urlText.setToolTipText(rootEObject.getSoundURL());
            } else {
                this.urlText.setText("");
                this.urlText.setToolTipText("");
            }
        }
    }

    protected SoundNotificationEffect testSound(String soundURL, float volume, boolean repeat) {
        final SoundNotificationEffect tmpEffect = ApogyAddonsMonitoringFactory.eINSTANCE.createSoundNotificationEffect();
        tmpEffect.setEnabled(true);
        tmpEffect.setSoundURL(soundURL);
        tmpEffect.setVolume(volume);
        tmpEffect.setRepeat(repeat);
        Job playJob = new Job("Test Sound Notification Effect."){

            protected IStatus run(IProgressMonitor arg0) {
                tmpEffect.activate(null, null);
                return Status.OK_STATUS;
            }
        };
        playJob.schedule();
        return tmpEffect;
    }
}

