/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.CSVLoggingNotificationEffect;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileURLComposite<RootEObject extends CSVLoggingNotificationEffect, ResolvedEObject extends CSVLoggingNotificationEffect>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, String> {
    private static final Logger Logger = LoggerFactory.getLogger(CSVFileURLComposite.class);
    private String urlString = null;
    private Text urlText;
    private Button selectButton;

    public CSVFileURLComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        try {
            Composite top = new Composite(parent, 64);
            top.setLayout((Layout)new GridLayout(3, false));
            this.urlText = new Text(top, 2048);
            GridData gridData = new GridData(16384, 0x1000000, true, false);
            gridData.minimumWidth = 400;
            gridData.widthHint = 400;
            this.urlText.setLayoutData((Object)gridData);
            this.selectButton = new Button(top, 8);
            this.selectButton.setText("Select...");
            this.selectButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    String currentDir = System.getProperty("user.dir");
                    FileDialog fileChooser = new FileDialog(CSVFileURLComposite.this.selectButton.getShell(), 8192);
                    fileChooser.setText("Select a file:");
                    fileChooser.setFilterPath(currentDir);
                    String[] extensions = new String[]{"*.csv"};
                    fileChooser.setFilterExtensions(extensions);
                    String filename = fileChooser.open();
                    if (filename != null) {
                        try {
                            String newURLString = CSVFileURLComposite.this.convertFilenameToURL(filename);
                            CSVFileURLComposite.this.setUrlString(newURLString);
                            ApogyCommonTransactionFacade.INSTANCE.basicSet(CSVFileURLComposite.this.getRootEObject(), (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.CSV_LOGGING_NOTIFICATION_EFFECT__FILE_URL, (Object)newURLString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            return top;
        }
        catch (Exception e) {
            Logger.error("Failed to open dialog !", (Throwable)e);
            return null;
        }
    }

    public String getUrlString() {
        return this.urlString;
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
        if (rootEObject != null) {
            this.urlText.setText(rootEObject.getFileURL());
            this.urlText.setToolTipText(rootEObject.getFileURL());
        } else {
            this.urlText.setText("");
            this.urlText.setToolTipText("");
        }
    }

    private void setUrlString(String newURLString) {
        this.urlString = newURLString;
        this.urlText.setText(newURLString);
    }

    private String convertFilenameToURL(String filename) throws Exception {
        File tmpFile = new File(filename);
        URL url = tmpFile.toURI().toURL();
        return url.toString();
    }
}

