/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.handlers;

import java.util.Iterator;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectPerspectiveHandler {
    private static final Logger Logger = LoggerFactory.getLogger(SelectPerspectiveHandler.class);

    @Execute
    public void execute(MApplication application, EPartService partService, EModelService modelService, Shell shell, @Optional @Named(value="perspectiveId") String perspectiveId) {
        MPerspective perspectiveResult = null;
        Logger.info("Selecting perspective <" + perspectiveId + ">...");
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)application);
        if (perspectiveStack != null) {
            Iterator perspectives = perspectiveStack.getChildren().iterator();
            while (perspectiveResult == null && perspectives.hasNext()) {
                MPerspective perspective = (MPerspective)perspectives.next();
                if (!perspective.getElementId().startsWith(perspectiveId)) continue;
                perspectiveResult = perspective;
            }
        }
        if (perspectiveResult != null) {
            Logger.info("Selected perspective <" + perspectiveResult.getTooltip() + ">.");
            partService.switchPerspective(perspectiveResult);
        } else {
            String message = "Unable to find the perspective:" + perspectiveId;
            Logger.error(message);
            MessageDialog.openError((Shell)shell, (String)"Error", (String)message);
        }
    }
}

