/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.services.logging.Activator;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.lifecycle.ProcessAdditions;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class E4LifeCycle {
    private ResourceSetListener resourceSetListener;
    private Adapter workspaceAdapter;
    private IEclipseContext eclipseContext;

    @PostContextCreate
    public void postContextCreate(IEclipseContext eclipseContext) {
        this.eclipseContext = eclipseContext;
        Activator.getDefault();
    }

    @ProcessAdditions
    public void processAdditions(final MApplication application, final EModelService modelService, final EPartService partService, final IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                E4LifeCycle.this.applicationStartupCompleted(application, modelService, partService);
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appShutdownStarted", new EventHandler(){

            public void handleEvent(Event event) {
                E4LifeCycle.this.applicationShutdownStarted();
                eventBroker.unsubscribe((EventHandler)this);
            }
        });
    }

    protected void applicationStartupCompleted(MApplication application, EModelService modelService, EPartService partService) {
        ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().addResourceSetListener(this.getResourceSetListener());
        ApogyWorkspaceFacade.INSTANCE.eAdapters().add((Object)this.getWorkspaceAdapter());
        MPerspective perspective = (MPerspective)modelService.find("org.eclipse.apogy.workspace.ui.perspectives.Welcome", (MUIElement)application);
        partService.switchPerspective(perspective);
    }

    private void applicationShutdownStarted() {
        ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().removeResourceSetListener(this.getResourceSetListener());
        ApogyWorkspaceFacade.INSTANCE.eAdapters().remove((Object)this.getWorkspaceAdapter());
    }

    private void updateUiTopics() {
        IEventBroker eventBroker = (IEventBroker)this.eclipseContext.get(IEventBroker.class.getName());
        if (eventBroker != null) {
            eventBroker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        }
    }

    private ResourceSetListener getResourceSetListener() {
        if (this.resourceSetListener == null) {
            this.resourceSetListener = new ResourceSetListenerImpl(){

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    E4LifeCycle.this.updateUiTopics();
                }
            };
        }
        return this.resourceSetListener;
    }

    private Adapter getWorkspaceAdapter() {
        if (this.workspaceAdapter == null) {
            this.workspaceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    E4LifeCycle.this.updateUiTopics();
                }
            };
        }
        return this.workspaceAdapter;
    }
}

