/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.KDTreeBasedPointLocator;
import org.eclipse.apogy.common.geometry.data3d.OutlierFilter;
import org.eclipse.apogy.common.geometry.data3d.impl.OutlierFilterImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class OutlierFilterCustomImpl
extends OutlierFilterImpl
implements OutlierFilter {
    public CartesianCoordinatesSet doProcess(CartesianCoordinatesSet input, IProgressMonitor monitor) throws Exception {
        KDTreeBasedPointLocator locator = ApogyCommonGeometryData3DFactory.eINSTANCE.createKDTreeBasedPointLocator();
        locator.addPoints((List<CartesianPositionCoordinates>)input.getPoints());
        LinkedList<CartesianPositionCoordinates> pointsToRemove = new LinkedList<CartesianPositionCoordinates>();
        for (CartesianPositionCoordinates point : input.getPoints()) {
            List<CartesianPositionCoordinates> pointsWithinRadius = locator.findPointsWithinRadius(point, this.getMaxDistance());
            if (pointsWithinRadius.size() > 1) continue;
            pointsToRemove.add(point);
        }
        for (CartesianPositionCoordinates point : pointsToRemove) {
            input.getPoints().remove((Object)point);
        }
        this.setOutput(input);
        return input;
    }
}

