/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.apogy.common.geometry.data3d.converters.URLToCartesianTriangularMeshConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLTRIToCartesianTriangularMeshConverter
extends URLToCartesianTriangularMeshConverter {
    private static final Logger Logger = LoggerFactory.getLogger(URLTRIToCartesianTriangularMeshConverter.class);
    private static String[] fileExtensions = new String[]{".tri"};

    public Class<?> getOutputType() {
        return CartesianTriangularMesh.class;
    }

    public Class<?> getInputType() {
        return URL.class;
    }

    @Override
    public String[] getSupportedFileExtension() {
        return fileExtensions;
    }

    public Object convert(Object input) throws Exception {
        CartesianTriangularMesh mesh = null;
        try {
            URL urlTri = (URL)input;
            URL urlxyz = this.createXYZURL(urlTri);
            File tempFileTri = this.copyURLContent(urlTri);
            File tempFileXYZ = this.copyURLContent(urlxyz);
            mesh = Data3DIO.INSTANCE.loadTriangularMeshFromTriXYZ(tempFileTri.getAbsolutePath(), tempFileXYZ.getAbsolutePath());
            if (mesh != null) {
                Logger.info("Sucessfully loaded CartesianTriangularMesh from URL<" + urlTri + ">.");
            } else {
                Logger.error("Could not load CartesianTriangularMesh from URL<" + urlTri + ">.");
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return mesh;
    }

    private URL createXYZURL(URL urlTri) throws Exception {
        int index = urlTri.toString().lastIndexOf(".");
        String newURLString = String.valueOf(urlTri.toString().substring(0, index + 1)) + "xyz";
        return new URL(newURLString);
    }
}

