/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbit;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.orbit.impl.EarthOrbitPropagatorImpl;
import org.eclipse.apogy.core.environment.orbit.Orbit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.orekit.errors.PropagationException;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EarthOrbitPropagatorCustomImpl
extends EarthOrbitPropagatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthOrbitPropagatorImpl.class);

    @Override
    public abstract Propagator getOreKitPropagator();

    @Override
    public List<org.eclipse.apogy.core.environment.orbit.SpacecraftState> getSpacecraftStates(final Date startDate, final Date endDate, double timeInterval) throws Exception {
        Propagator propagator = this.getOreKitPropagator();
        double duration = (double)(endDate.getTime() - startDate.getTime()) * 0.001;
        final ArrayList<org.eclipse.apogy.core.environment.orbit.SpacecraftState> states = new ArrayList<org.eclipse.apogy.core.environment.orbit.SpacecraftState>();
        propagator.setMasterMode(timeInterval, new OrekitFixedStepHandler(){

            public void init(SpacecraftState spacecraftState, AbsoluteDate arg1) throws PropagationException {
            }

            public void handleStep(SpacecraftState spacecraftState, boolean arg1) throws PropagationException {
                try {
                    Date date = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(spacecraftState.getDate());
                    if (date.getTime() >= startDate.getTime() && endDate.getTime() >= date.getTime()) {
                        EarthOrbit orbit = null;
                        if (spacecraftState.getOrbit() instanceof KeplerianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createKeplerianOrbit((KeplerianOrbit)spacecraftState.getOrbit());
                        } else if (spacecraftState.getOrbit() instanceof CartesianOrbit) {
                            orbit = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createCartesianEarthOrbit((CartesianOrbit)spacecraftState.getOrbit());
                        }
                        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createOreKitBackedSpacecraftState(orbit, spacecraftState);
                        states.add(ss);
                    }
                }
                catch (PropagationException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PropagationException((Throwable)e, null, new Object[]{this});
                }
            }
        });
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(startDate);
        try {
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, duration));
            org.eclipse.apogy.core.environment.orbit.SpacecraftState startState = this.propagate(startDate);
            states.add(0, startState);
            org.eclipse.apogy.core.environment.orbit.SpacecraftState endState = this.propagate(endDate);
            states.add(endState);
        }
        catch (PropagationException e) {
            Logger.error("Error occured during execution.", (Throwable)e);
            throw e;
        }
        return states;
    }

    @Override
    public org.eclipse.apogy.core.environment.orbit.SpacecraftState propagate(Date targetDate) throws Exception {
        Propagator propagator = this.getOreKitPropagator();
        AbsoluteDate targetAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(targetDate);
        propagator.setSlaveMode();
        SpacecraftState ss = propagator.propagate(targetAbsoluteDate);
        Orbit orbitCopy = (Orbit)EcoreUtil.copy((EObject)this.getInitialOrbit());
        return ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createSpacecraftState(orbitCopy, ss);
    }
}

