/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraftOrbitHistory;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.GroundStation;
import org.eclipse.apogy.core.environment.earth.orbit.ObservationTarget;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisResult;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.impl.AbstractOrbitAnalysisProcessorImpl;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOrbitAnalysisProcessorCustomImpl
extends AbstractOrbitAnalysisProcessorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractOrbitAnalysisProcessorCustomImpl.class);

    public OrbitAnalysisResult doProcess(OrbitAnalysisData input, IProgressMonitor progressMonitor) throws Exception {
        int maxNumberOfThreads;
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_ORBIT_ANALYSIS_PROCESSOR__ANALYSIS_COMPUTATION_CLOCK_TIME, (Object)0.0);
        Logger.info("Processing Orbital Data started");
        double analysisPeriod = (double)(input.getToDate().getTime() - input.getFromDate().getTime()) * 0.001 / 3600.0;
        Logger.info("------------------------------------------");
        Logger.info("Analysis Period (hours)                 : " + analysisPeriod);
        Logger.info("Number of S/C                           : " + input.getSpacecrafts().size());
        Logger.info("Number of Targets                       : " + input.getObservationTargets().size());
        Logger.info("Number of Ground Station                : " + input.getGroundStations().size());
        Logger.info("Passes Position Time Interval (s)       : " + this.getVisibilityPassesPositionsTimeInterval());
        Logger.info("Eclipses Position Time Interval (s)     : " + this.getEclipsesPositionsTimeInterval());
        Logger.info("Orbit Position Time Interval (s)        : " + this.getOrbitPositionsTimeInterval());
        Logger.info("Passes Pre-Processing Time Interval (s) : " + this.getVisibilityPassesPreProcessingTimeInterval());
        long startTime = System.currentTimeMillis();
        OrbitAnalysisResult result = this.createOrbitAnalysisResultInstance();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)input, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__RESULT, (Object)result, true);
        int spacecraftsCount = input.getSpacecrafts().size();
        int n = maxNumberOfThreads = this.getMaxNumberThreads() < 1 ? Runtime.getRuntime().availableProcessors() : this.getMaxNumberThreads();
        if (maxNumberOfThreads > spacecraftsCount) {
            // empty if block
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Orbit Analysis Processor", (int)spacecraftsCount);
        JobGroup jobGroup = new JobGroup("Orbit Analysis Processor", 0, spacecraftsCount);
        Iterator spacecrafts = input.getSpacecrafts().iterator();
        ArrayList<SpacecraftProcessingJob> spacecraftJobs = new ArrayList<SpacecraftProcessingJob>();
        while (spacecrafts.hasNext()) {
            SpacecraftProcessingJob job = new SpacecraftProcessingJob((EarthSpacecraft)spacecrafts.next(), input, result, (IProgressMonitor)subMonitor);
            spacecraftJobs.add(job);
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        jobGroup.join(0L, progressMonitor);
        for (SpacecraftProcessingJob job : spacecraftJobs) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)result, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__GROUND_STATION_VISIBILITY_PASSES, job.getGroundStationPasses(), true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)result, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__OBSERVATION_TARGET_VISIBILITY_PASSES, job.getObservationTargetPasses(), true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)result, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__ECLIPSES, job.getEclipses(), true);
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)result, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_RESULT__SPACECRAFT_TRAJECTORIES, (Object)job.getTrajectory(), true);
        }
        long endTime = System.currentTimeMillis();
        double durationSeconds = (double)(endTime - startTime) * 0.001;
        Logger.info("Processing Orbital Data completed in " + durationSeconds + " seconds.");
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_ORBIT_ANALYSIS_PROCESSOR__ANALYSIS_COMPUTATION_CLOCK_TIME, (Object)durationSeconds);
        Logger.info("Observation Target Passes  : " + result.getObservationTargetVisibilityPasses().size());
        Logger.info("Ground Station Passes      : " + result.getGroundStationVisibilityPasses().size());
        Logger.info("Eclipes                    : " + result.getEclipses().size());
        Logger.info("------------------------------------------");
        return result;
    }

    @Override
    public OrbitAnalysisResult createOrbitAnalysisResultInstance() {
        return ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createOrbitAnalysisResult();
    }

    protected class OldSpacecraftProcessingJob
    extends Job {
        private EarthSpacecraft spacecraft;
        private OrbitAnalysisData analysisData;
        private OrbitAnalysisResult analysisResult;
        private List<VisibilityPass> groundStationPasses;
        private List<VisibilityPass> observationTargetPasses;
        private List<Eclipse> eclipses;
        private EarthSpacecraftOrbitHistory trajectory;

        public OldSpacecraftProcessingJob(EarthSpacecraft spacecraft, OrbitAnalysisData analysisData, OrbitAnalysisResult analysisResult, IProgressMonitor monitor) {
            super("Process " + spacecraft.getName() == null ? "Unnamed" : spacecraft.getName());
            this.groundStationPasses = new ArrayList<VisibilityPass>();
            this.observationTargetPasses = new ArrayList<VisibilityPass>();
            this.eclipses = new ArrayList<Eclipse>();
            this.spacecraft = spacecraft;
            this.analysisData = analysisData;
            this.analysisResult = analysisResult;
        }

        public Collection<VisibilityPass> getObservationTargetPasses() {
            return this.observationTargetPasses;
        }

        public Collection<VisibilityPass> getGroundStationPasses() {
            return this.groundStationPasses;
        }

        public Collection<Eclipse> getEclipses() {
            return this.eclipses;
        }

        public EarthSpacecraftOrbitHistory getTrajectory() {
            return this.trajectory;
        }

        protected IStatus run(IProgressMonitor progressMonitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
            try {
                ArrayList<Object> allLocations = new ArrayList<Object>();
                allLocations.addAll((Collection<Object>)this.analysisData.getObservationTargets());
                allLocations.addAll((Collection<Object>)this.analysisData.getGroundStations());
                List<VisibilityPass> visibilityPasses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getVisibilityPasses(this.spacecraft, allLocations, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getVisibilityPassesPositionsTimeInterval(), (IProgressMonitor)subMonitor);
                for (VisibilityPass visibilityPass : visibilityPasses) {
                    if (visibilityPass.getOutlook() instanceof GroundStation) {
                        this.groundStationPasses.add(visibilityPass);
                        continue;
                    }
                    if (!(visibilityPass.getOutlook() instanceof ObservationTarget)) continue;
                    this.observationTargetPasses.add(visibilityPass);
                }
                subMonitor.worked(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            try {
                this.eclipses.addAll(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipses(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getEclipsesPositionsTimeInterval(), (IProgressMonitor)subMonitor));
                subMonitor.worked(1);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            try {
                List<SpacecraftState> spacecraftStates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStates(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getOrbitPositionsTimeInterval(), (IProgressMonitor)subMonitor);
                TreeSet<SpacecraftState> sorted = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
                sorted.addAll(spacecraftStates);
                for (Eclipse eclipse : this.eclipses) {
                    if (eclipse.getPenumbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraEntry().getTime()));
                    }
                    if (eclipse.getPenumbraExit() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraExit().getTime()));
                    }
                    if (eclipse.getUmbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraEntry().getTime()));
                    }
                    if (eclipse.getUmbraExit() == null) continue;
                    sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraExit().getTime()));
                }
                this.trajectory = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEarthSpacecraftOrbitHistory();
                this.trajectory.setSpacecraft(this.spacecraft);
                this.trajectory.setFromDate(this.analysisData.getFromDate());
                this.trajectory.setToDate(this.analysisData.getToDate());
                this.trajectory.getSpacecraftStates().addAll(sorted);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
                return Status.CANCEL_STATUS;
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }
    }

    protected class SpacecraftProcessingJob
    extends Job {
        private EarthSpacecraft spacecraft;
        private OrbitAnalysisData analysisData;
        private OrbitAnalysisResult analysisResult;
        private SortedSet<SpacecraftState> spacecraftStates;
        private long[] timeStamps;
        private GeographicCoordinates[] spacecraftPositions;
        private List<VisibilityPass> groundStationPasses;
        private List<VisibilityPass> observationTargetPasses;
        private List<Eclipse> eclipses;
        private EarthSpacecraftOrbitHistory trajectory;
        protected DecimalFormat durationFormat;

        public SpacecraftProcessingJob(EarthSpacecraft spacecraft, OrbitAnalysisData analysisData, OrbitAnalysisResult analysisResult, IProgressMonitor monitor) {
            super("Process " + spacecraft.getName() == null ? "Unnamed" : spacecraft.getName());
            this.timeStamps = null;
            this.groundStationPasses = new ArrayList<VisibilityPass>();
            this.observationTargetPasses = new ArrayList<VisibilityPass>();
            this.eclipses = new ArrayList<Eclipse>();
            this.durationFormat = new DecimalFormat("0.00");
            this.spacecraft = spacecraft;
            this.analysisData = analysisData;
            this.analysisResult = analysisResult;
        }

        public Collection<VisibilityPass> getObservationTargetPasses() {
            return this.observationTargetPasses;
        }

        public Collection<VisibilityPass> getGroundStationPasses() {
            return this.groundStationPasses;
        }

        public Collection<Eclipse> getEclipses() {
            return this.eclipses;
        }

        public EarthSpacecraftOrbitHistory getTrajectory() {
            return this.trajectory;
        }

        protected IStatus run(IProgressMonitor progressMonitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)3);
            try {
                this.findVisibilityPassesSingleThread((IProgressMonitor)subMonitor);
                this.findEclipses((IProgressMonitor)subMonitor);
                this.postProcessTrajectoryAndEclipses((IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            subMonitor.done();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - void declaration
         */
        protected void findVisibilityPassesParallelized(IProgressMonitor subMonitor) throws Exception {
            try {
                long startTime = System.currentTimeMillis();
                Date fromDate = this.analysisData.getFromDate();
                Date toDate = this.analysisData.getToDate();
                List<SpacecraftState> tmpSpacecraftStates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStates(this.spacecraft, fromDate, toDate, AbstractOrbitAnalysisProcessorCustomImpl.this.getVisibilityPassesPreProcessingTimeInterval(), subMonitor);
                this.spacecraftStates = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
                this.spacecraftStates.addAll(tmpSpacecraftStates);
                this.timeStamps = new long[this.spacecraftStates.size()];
                this.spacecraftPositions = new GeographicCoordinates[this.spacecraftStates.size()];
                int i = 0;
                for (SpacecraftState spacecraftState : this.spacecraftStates) {
                    GeographicCoordinates geographicCoordinates;
                    this.timeStamps[i] = spacecraftState.getTime().getTime();
                    this.spacecraftPositions[i] = geographicCoordinates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)spacecraftState);
                    ++i;
                }
                ArrayList<Object> locations = new ArrayList<Object>();
                locations.addAll((Collection<Object>)this.analysisData.getObservationTargets());
                locations.addAll((Collection<Object>)this.analysisData.getGroundStations());
                HashMap<EarthOutlook, ElevationValues> earthOutlookToVectorMap = new HashMap<EarthOutlook, ElevationValues>();
                for (EarthOutlook earthOutlook : locations) {
                    ElevationValues elevationValues = new ElevationValues(earthOutlook, this.timeStamps.length);
                    earthOutlookToVectorMap.put(earthOutlook, elevationValues);
                }
                boolean bl = false;
                Iterator iterator = this.spacecraftStates.iterator();
                while (iterator.hasNext()) {
                    void var10_13;
                    SpacecraftState cfr_ignored_0 = (SpacecraftState)iterator.next();
                    GeographicCoordinates geographicCoordinates = this.spacecraftPositions[var10_13];
                    for (EarthOutlook earthOutlook : locations) {
                        ElevationValues values = (ElevationValues)earthOutlookToVectorMap.get(earthOutlook);
                        values.elevation[var10_13] = this.computeElevation(earthOutlook.getLatitude(), earthOutlook.getLongitude(), earthOutlook.getElevation(), geographicCoordinates.getLatitude(), geographicCoordinates.getLongitude(), geographicCoordinates.getElevation());
                    }
                    ++var10_13;
                }
                for (EarthOutlook earthOutlook : locations) {
                    this.computePassCandidates((ElevationValues)earthOutlookToVectorMap.get(earthOutlook));
                }
                ArrayList<ElevationValues> arrayList = new ArrayList<ElevationValues>();
                for (EarthOutlook earthOutlook : locations) {
                    ElevationValues azimuthElevationValues = (ElevationValues)earthOutlookToVectorMap.get(earthOutlook);
                    arrayList.add(azimuthElevationValues);
                }
                List<List<ElevationValues>> list = this.createVisibilityPassesRefinementGroup(arrayList);
                JobGroup jobGroup = new JobGroup("Visibility Passes", 0, list.size());
                ArrayList<VisibilityPassesRefinementJob> refinementJobs = new ArrayList<VisibilityPassesRefinementJob>();
                int jobIndex = 0;
                for (List<ElevationValues> group : list) {
                    VisibilityPassesRefinementJob job = new VisibilityPassesRefinementJob("Visibility Passes Refinement " + jobIndex, group);
                    refinementJobs.add(job);
                    job.setJobGroup(jobGroup);
                    job.schedule();
                    ++jobIndex;
                }
                jobGroup.join(0L, AbstractOrbitAnalysisProcessorCustomImpl.this.progressMonitor);
                ArrayList<VisibilityPass> visibilityPasses = new ArrayList<VisibilityPass>();
                for (VisibilityPassesRefinementJob job : refinementJobs) {
                    visibilityPasses.addAll(job.computedPasses);
                }
                for (VisibilityPass visibilityPass : visibilityPasses) {
                    if (visibilityPass.getOutlook() instanceof GroundStation) {
                        this.groundStationPasses.add(visibilityPass);
                        continue;
                    }
                    if (!(visibilityPass.getOutlook() instanceof ObservationTarget)) continue;
                    this.observationTargetPasses.add(visibilityPass);
                }
                long stopTime = System.currentTimeMillis();
                Logger.info("Found <" + visibilityPasses.size() + "> passes for Spacecraft <" + this.spacecraft.getName() + "> in <" + this.durationFormat.format((double)(stopTime - startTime) * 0.001) + "> seconds.");
                subMonitor.worked(1);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void findVisibilityPassesSingleThread(IProgressMonitor subMonitor) throws Exception {
            try {
                long startTime = System.currentTimeMillis();
                Date fromDate = this.analysisData.getFromDate();
                Date toDate = this.analysisData.getToDate();
                List<SpacecraftState> tmpSpacecraftStates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStates(this.spacecraft, fromDate, toDate, AbstractOrbitAnalysisProcessorCustomImpl.this.getVisibilityPassesPreProcessingTimeInterval(), subMonitor);
                this.spacecraftStates = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
                this.spacecraftStates.addAll(tmpSpacecraftStates);
                this.timeStamps = new long[this.spacecraftStates.size()];
                this.spacecraftPositions = new GeographicCoordinates[this.spacecraftStates.size()];
                int i = 0;
                for (SpacecraftState spacecraftState : this.spacecraftStates) {
                    GeographicCoordinates geographicCoordinates;
                    this.timeStamps[i] = spacecraftState.getTime().getTime();
                    this.spacecraftPositions[i] = geographicCoordinates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)spacecraftState);
                    ++i;
                }
                ArrayList<Object> locations = new ArrayList<Object>();
                locations.addAll((Collection<Object>)this.analysisData.getObservationTargets());
                locations.addAll((Collection<Object>)this.analysisData.getGroundStations());
                HashMap<EarthOutlook, ElevationValues> earthOutlookToVectorMap = new HashMap<EarthOutlook, ElevationValues>();
                for (EarthOutlook earthOutlook : locations) {
                    ElevationValues values = new ElevationValues(earthOutlook, this.timeStamps.length);
                    earthOutlookToVectorMap.put(earthOutlook, values);
                }
                boolean bl = false;
                Iterator iterator = this.spacecraftStates.iterator();
                while (iterator.hasNext()) {
                    void var10_13;
                    SpacecraftState cfr_ignored_0 = (SpacecraftState)iterator.next();
                    GeographicCoordinates spacecraftCoords = this.spacecraftPositions[var10_13];
                    for (EarthOutlook earthOutlook : locations) {
                        ElevationValues elevationValues = (ElevationValues)earthOutlookToVectorMap.get(earthOutlook);
                        elevationValues.elevation[var10_13] = this.computeElevation(earthOutlook.getLatitude(), earthOutlook.getLongitude(), earthOutlook.getElevation(), spacecraftCoords.getLatitude(), spacecraftCoords.getLongitude(), spacecraftCoords.getElevation());
                    }
                    ++var10_13;
                }
                long timeBuffer = 60000L;
                for (EarthOutlook earthOutlook : locations) {
                    this.computePassCandidates((ElevationValues)earthOutlookToVectorMap.get(earthOutlook));
                }
                SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)subMonitor, (int)locations.size());
                ArrayList<VisibilityPass> visibilityPasses = new ArrayList<VisibilityPass>();
                for (EarthOutlook earthOutlook : locations) {
                    ElevationValues azimuthElevationValues = (ElevationValues)earthOutlookToVectorMap.get(earthOutlook);
                    ArrayList<EarthOutlook> tmpLocations = new ArrayList<EarthOutlook>();
                    tmpLocations.add(earthOutlook);
                    for (Interval interval : azimuthElevationValues.passCandidates) {
                        Date from = null;
                        Date to = null;
                        if (interval.fromDate > 0L) {
                            from = new Date(interval.fromDate - timeBuffer);
                        }
                        if (interval.toDate > 0L) {
                            to = new Date(interval.toDate + timeBuffer);
                        }
                        if (from != null && to != null) {
                            List<VisibilityPass> targetPasses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getVisibilityPasses(this.spacecraft, tmpLocations, from, to, this.analysisData.getActiveProcessor().getVisibilityPassesPositionsTimeInterval(), subMonitor);
                            visibilityPasses.addAll(targetPasses);
                        }
                        subMonitor2.worked(1);
                    }
                }
                for (VisibilityPass visibilityPass : visibilityPasses) {
                    if (visibilityPass.getOutlook() instanceof GroundStation) {
                        this.groundStationPasses.add(visibilityPass);
                        continue;
                    }
                    if (!(visibilityPass.getOutlook() instanceof ObservationTarget)) continue;
                    this.observationTargetPasses.add(visibilityPass);
                }
                long l = System.currentTimeMillis();
                Logger.info("Found <" + visibilityPasses.size() + "> passes for Spacecraft <" + this.spacecraft.getName() + "> in <" + this.durationFormat.format((double)(l - startTime) * 0.001) + "> seconds.");
                subMonitor.worked(1);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
            }
        }

        protected void findEclipses(IProgressMonitor subMonitor) {
            try {
                long startTime = System.currentTimeMillis();
                this.eclipses.addAll(ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipses(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getEclipsesPositionsTimeInterval(), subMonitor));
                long stopTime = System.currentTimeMillis();
                Logger.info("Found <" + this.eclipses.size() + "> eclipses for Spacecraft <" + this.spacecraft.getName() + "> in <" + this.durationFormat.format((double)(stopTime - startTime) * 0.001) + "> seconds.");
                subMonitor.worked(1);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
            }
        }

        protected void postProcessTrajectoryAndEclipses(IProgressMonitor subMonitor) {
            try {
                long startTime = System.currentTimeMillis();
                List<SpacecraftState> spacecraftStates = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getSpacecraftStates(this.spacecraft, this.analysisData.getFromDate(), this.analysisData.getToDate(), this.analysisData.getActiveProcessor().getOrbitPositionsTimeInterval(), subMonitor);
                TreeSet<SpacecraftState> sorted = new TreeSet<SpacecraftState>(new SpacecraftStateDateComparator());
                sorted.addAll(spacecraftStates);
                for (Eclipse eclipse : this.eclipses) {
                    if (eclipse.getPenumbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraEntry().getTime()));
                    }
                    if (eclipse.getPenumbraExit() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getPenumbraExit().getTime()));
                    }
                    if (eclipse.getUmbraEntry() != null) {
                        sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraEntry().getTime()));
                    }
                    if (eclipse.getUmbraExit() == null) continue;
                    sorted.add(((EarthOrbitModel)this.spacecraft.getOrbitModel()).propagate(eclipse.getUmbraExit().getTime()));
                }
                this.trajectory = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createEarthSpacecraftOrbitHistory();
                this.trajectory.setSpacecraft(this.spacecraft);
                this.trajectory.setFromDate(this.analysisData.getFromDate());
                this.trajectory.setToDate(this.analysisData.getToDate());
                this.trajectory.getSpacecraftStates().addAll(sorted);
                long stopTime = System.currentTimeMillis();
                Logger.info("Trajectory for Spacecraft <" + this.spacecraft.getName() + "> computed in <" + this.durationFormat.format((double)(stopTime - startTime) * 0.001) + "> seconds.");
                subMonitor.worked(1);
            }
            catch (Exception exception) {
                subMonitor.done();
                this.cancel();
            }
        }

        private float computeElevation(double targetLatitude, double targetLongitude, double targetAltitude, double spacecraftLatitude, double spacecraftLongitude, double spacecraftAltitude) {
            double R = 6371000.0;
            double \u03c61 = targetLatitude;
            double \u03c62 = spacecraftLatitude;
            double \u0394\u03c6 = spacecraftLatitude - targetLatitude;
            double \u0394\u03bb = spacecraftLongitude - targetLongitude;
            double a = Math.sin(\u0394\u03c6 / 2.0) * Math.sin(\u0394\u03c6 / 2.0) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.sin(\u0394\u03bb / 2.0) * Math.sin(\u0394\u03bb / 2.0);
            double cc = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            double distance = R * cc;
            double zeta = distance / R;
            double aSide = R + spacecraftAltitude;
            double bSide = R + targetAltitude;
            double cSide = Math.sqrt(aSide * aSide + bSide * bSide - 2.0 * aSide * bSide * Math.cos(zeta));
            double alpha = Math.acos((bSide * bSide + cSide * cSide - aSide * aSide) / (2.0 * bSide * cSide));
            return (float)(alpha -= Math.toRadians(90.0));
        }

        private void computePassCandidates(ElevationValues azimuthElevationValues) {
            if (azimuthElevationValues.elevation.length > 1) {
                Interval interval = new Interval(-1L, -1L);
                float previous = azimuthElevationValues.elevation[0];
                int i = 1;
                while (i < azimuthElevationValues.elevation.length) {
                    float current = azimuthElevationValues.elevation[i];
                    if (previous < 0.0f && current > 0.0f) {
                        interval.fromDate = this.timeStamps[i];
                    } else if (previous > 0.0f && current < 0.0f) {
                        interval.toDate = this.timeStamps[i];
                        azimuthElevationValues.passCandidates.add(interval);
                        interval = new Interval(-1L, -1L);
                    }
                    previous = current;
                    ++i;
                }
            }
        }

        private List<List<ElevationValues>> createVisibilityPassesRefinementGroup(List<ElevationValues> elevationValuesList) {
            int maxNumberOfJobs = 4;
            ArrayList<List<ElevationValues>> groups = new ArrayList<List<ElevationValues>>();
            if (elevationValuesList.size() > maxNumberOfJobs) {
                int itemsPerGroup = (int)Math.ceil(elevationValuesList.size() / maxNumberOfJobs);
                int index = 0;
                ArrayList<ElevationValues> group = null;
                while (index < elevationValuesList.size()) {
                    if (Math.IEEEremainder(index, itemsPerGroup) == 0.0) {
                        group = new ArrayList<ElevationValues>();
                        groups.add(group);
                    }
                    group.add(elevationValuesList.get(index));
                    ++index;
                }
            } else {
                ArrayList<ElevationValues> group = new ArrayList<ElevationValues>();
                group.addAll(elevationValuesList);
                groups.add(group);
            }
            return groups;
        }

        private class ElevationValues {
            public EarthOutlook earthOutlook;
            public float[] elevation;
            public Collection<Interval> passCandidates = new ArrayList<Interval>();

            public ElevationValues(EarthOutlook earthOutlook, int size) {
                this.earthOutlook = earthOutlook;
                this.elevation = new float[size];
            }
        }

        private class Interval {
            long fromDate = -1L;
            long toDate = -1L;

            public Interval(long from, long to) {
                this.fromDate = from;
                this.toDate = to;
            }
        }

        private class VisibilityPassesRefinementJob
        extends Job {
            public Collection<ElevationValues> azimuthElevationValues;
            public Collection<VisibilityPass> computedPasses;

            public VisibilityPassesRefinementJob(String jobName, Collection<ElevationValues> azimuthElevationValues) {
                super(jobName);
                this.azimuthElevationValues = new ArrayList<ElevationValues>();
                this.computedPasses = new ArrayList<VisibilityPass>();
                this.azimuthElevationValues.addAll(azimuthElevationValues);
            }

            protected IStatus run(IProgressMonitor monitor) {
                long timeBuffer = Math.round(AbstractOrbitAnalysisProcessorCustomImpl.this.getVisibilityPassesPreProcessingTimeInterval() * 1000.0);
                for (ElevationValues elevationValues : this.azimuthElevationValues) {
                    for (Interval interval : elevationValues.passCandidates) {
                        Date from = null;
                        Date to = null;
                        ArrayList<EarthOutlook> tmpLocations = new ArrayList<EarthOutlook>();
                        tmpLocations.add(elevationValues.earthOutlook);
                        if (interval.fromDate > 0L) {
                            from = new Date(interval.fromDate - timeBuffer);
                        }
                        if (interval.toDate > 0L) {
                            to = new Date(interval.toDate + timeBuffer);
                        }
                        if (from == null || to == null) continue;
                        try {
                            List<VisibilityPass> targetPasses = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getVisibilityPasses(SpacecraftProcessingJob.this.spacecraft, tmpLocations, from, to, SpacecraftProcessingJob.this.analysisData.getActiveProcessor().getVisibilityPassesPositionsTimeInterval(), monitor);
                            this.computedPasses.addAll(targetPasses);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        }
    }

    private class SpacecraftStateDateComparator
    implements Comparator<SpacecraftState> {
        private SpacecraftStateDateComparator() {
        }

        @Override
        public int compare(SpacecraftState o1, SpacecraftState o2) {
            long o2Date;
            long o1Date = o1.getTime().getTime();
            if (o1Date > (o2Date = o2.getTime().getTime())) {
                return 1;
            }
            if (o1Date < o2Date) {
                return -1;
            }
            return 0;
        }
    }
}

