/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.SunElevationAtTargetCostFunctionImpl;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;

public class SunElevationAtTargetCostFunctionCustomImpl
extends SunElevationAtTargetCostFunctionImpl {
    @Override
    public double computeCost(VisibilityPass pass) {
        Map<Date, Double> elevationVsTime = this.computeSunElevationVsTime(pass);
        double minimumElevation = Math.toDegrees(this.findMinimumSunElevation(elevationVsTime));
        if (minimumElevation < this.getMinimumSunElevationAngle()) {
            return Double.POSITIVE_INFINITY;
        }
        double maximumElevation = Math.toDegrees(this.findMaximumSunElevation(elevationVsTime));
        if (maximumElevation > this.getMaximumSunElevationAngle()) {
            return Double.POSITIVE_INFINITY;
        }
        return 0.0;
    }

    protected Map<Date, Double> computeSunElevationVsTime(VisibilityPass pass) {
        HashMap<Date, Double> elevationVsTime = new HashMap<Date, Double>();
        double observerLongitude = pass.getOutlook().getLongitude();
        double observerLatitude = pass.getOutlook().getLatitude();
        for (VisibilityPassSpacecraftPosition position : pass.getPositionHistory().getPositions()) {
            HorizontalCoordinates sunCoords = AstronomyUtils.INSTANCE.getHorizontalSunPosition(position.getTime(), observerLongitude, observerLatitude);
            elevationVsTime.put(position.getTime(), sunCoords.getAltitude());
        }
        return elevationVsTime;
    }

    protected double findMinimumSunElevation(Map<Date, Double> elevationVsTime) {
        double minimum = Double.POSITIVE_INFINITY;
        for (Double elevation : elevationVsTime.values()) {
            if (!(elevation < minimum)) continue;
            minimum = elevation;
        }
        return minimum;
    }

    protected double findMaximumSunElevation(Map<Date, Double> elevationVsTime) {
        double maximum = Double.NEGATIVE_INFINITY;
        for (Double elevation : elevationVsTime.values()) {
            if (!(elevation > maximum)) continue;
            maximum = elevation;
        }
        return maximum;
    }
}

