/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.SpacecraftAboveGroundStationCostFunctionImpl;

public class SpacecraftAboveGroundStationCostFunctionCustomImpl
extends SpacecraftAboveGroundStationCostFunctionImpl {
    protected Map<EarthSpacecraft, Collection<VisibilityPass>> spacecraftToGroundStationPassesMap;

    @Override
    public void initialize(OrbitAnalysisData orbitAnalysisData) {
        super.initialize(orbitAnalysisData);
        this.spacecraftToGroundStationPassesMap = new HashMap<EarthSpacecraft, Collection<VisibilityPass>>();
        for (EarthSpacecraft spacecraft : orbitAnalysisData.getSpacecrafts()) {
            List eclipses = orbitAnalysisData.getResult().getGroundStationVisibilityPasses(spacecraft);
            this.spacecraftToGroundStationPassesMap.put(spacecraft, eclipses);
        }
    }

    @Override
    public double computeCost(VisibilityPass pass) {
        Collection<VisibilityPass> applicableGroundStationPasses = this.spacecraftToGroundStationPassesMap.get(pass.getSpacecraft());
        if (applicableGroundStationPasses != null && !applicableGroundStationPasses.isEmpty()) {
            for (VisibilityPass groundStationPass : applicableGroundStationPasses) {
                if (!ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, (TimeInterval)groundStationPass)) continue;
                return this.getCost();
            }
        }
        return 0.0;
    }
}

