/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.EclipseCostFunctionImpl;

public class EclipseCostFunctionCustomImpl
extends EclipseCostFunctionImpl {
    protected Map<EarthSpacecraft, Collection<Eclipse>> spacecraftToEclipseMap;

    @Override
    public void initialize(OrbitAnalysisData orbitAnalysisData) {
        super.initialize(orbitAnalysisData);
        this.spacecraftToEclipseMap = new HashMap<EarthSpacecraft, Collection<Eclipse>>();
        for (EarthSpacecraft spacecraft : orbitAnalysisData.getSpacecrafts()) {
            List eclipses = orbitAnalysisData.getResult().getEclipses(spacecraft);
            this.spacecraftToEclipseMap.put(spacecraft, eclipses);
        }
    }

    @Override
    public double computeCost(VisibilityPass pass) {
        double cost = 0.0;
        Collection<Eclipse> applicableEclipses = this.spacecraftToEclipseMap.get(pass.getSpacecraft());
        if (applicableEclipses != null && !applicableEclipses.isEmpty()) {
            block5: for (Eclipse eclipse : applicableEclipses) {
                TimeInterval umbraInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraEntryInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                TimeInterval penumbraExitInterval = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getEclipseIntervals(eclipse, pass.getFromDate(), pass.getToDate(), umbraInterval, penumbraEntryInterval, penumbraExitInterval);
                switch (this.getEclipsePeriod().getValue()) {
                    case 0: {
                        if (ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, umbraInterval) || ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, penumbraEntryInterval) || ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, penumbraExitInterval)) continue block5;
                        cost = this.getCost();
                        break;
                    }
                    case 2: {
                        if (!ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, umbraInterval)) break;
                        cost = this.getCost();
                        break;
                    }
                    case 1: {
                        if (!ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, penumbraEntryInterval) && !ApogyCommonEMFFacade.INSTANCE.areTimeIntervalsOverlaping((TimeInterval)pass, penumbraExitInterval)) continue block5;
                        cost = this.getCost();
                        break;
                    }
                }
            }
        }
        return cost;
    }
}

