/*
 * Decompiled with CFR 0.152.
 */
package gazebo_msgs;

import geometry_msgs.Point;
import geometry_msgs.Wrench;
import org.ros.internal.message.Message;
import org.ros.message.Duration;
import org.ros.message.Time;

public interface ApplyBodyWrenchRequest
extends Message {
    public static final String _TYPE = "gazebo_msgs/ApplyBodyWrenchRequest";
    public static final String _DEFINITION = "# Apply Wrench to Gazebo Body.\n# via the callback mechanism\n# all Gazebo operations are made in world frame\nstring body_name                          # Gazebo body to apply wrench (linear force and torque)\n                                          # wrench is applied in the gazebo world by default\n                                          # body names are prefixed by model name, e.g. pr2::base_link\nstring reference_frame                    # wrench is defined in the reference frame of this entity\n                                          # use inertial frame if left empty\n                                          # frame names are bodies prefixed by model name, e.g. pr2::base_link\ngeometry_msgs/Point  reference_point      # wrench is defined at this location in the reference frame\ngeometry_msgs/Wrench wrench               # wrench applied to the origin of the body\ntime start_time                           # (optional) wrench application start time (seconds)\n                                          # if start_time is not specified, or\n                                          # start_time < current time, start as soon as possible\nduration duration                         # optional duration of wrench application time (seconds)\n                                          # if duration < 0, apply wrench continuously without end\n                                          # if duration = 0, do nothing\n                                          # if duration < step size, apply wrench\n                                          # for one step size\n";

    public String getBodyName();

    public void setBodyName(String var1);

    public String getReferenceFrame();

    public void setReferenceFrame(String var1);

    public Point getReferencePoint();

    public void setReferencePoint(Point var1);

    public Wrench getWrench();

    public void setWrench(Wrench var1);

    public Time getStartTime();

    public void setStartTime(Time var1);

    public Duration getDuration();

    public void setDuration(Duration var1);
}

