/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.utilities;

import geometry_msgs.Pose;
import geometry_msgs.PoseStamped;
import geometry_msgs.Transform;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix4x4;

public class GeometryUtils {
    public static Matrix4x4 rosTransformToMatrix(Transform rosTransform) {
        Quat4d quat4dPose = new Quat4d(rosTransform.getRotation().getX(), rosTransform.getRotation().getY(), rosTransform.getRotation().getZ(), rosTransform.getRotation().getW());
        Matrix3d rotationMatrix = new Matrix3d();
        rotationMatrix.setIdentity();
        rotationMatrix.set(quat4dPose);
        Matrix4d transformMatrix = new Matrix4d();
        transformMatrix.setIdentity();
        transformMatrix.set(rotationMatrix);
        transformMatrix.setM03(rosTransform.getTranslation().getX());
        transformMatrix.setM13(rosTransform.getTranslation().getY());
        transformMatrix.setM23(rosTransform.getTranslation().getZ());
        transformMatrix.setM33(1.0);
        Matrix4x4 pose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(transformMatrix);
        return pose;
    }

    public static Matrix4x4 rosPoseToMatrix(Pose rosPose) {
        Quat4d quat4dPose = new Quat4d(rosPose.getOrientation().getX(), rosPose.getOrientation().getY(), rosPose.getOrientation().getZ(), rosPose.getOrientation().getW());
        Matrix3d rotationMatrix = new Matrix3d();
        rotationMatrix.setIdentity();
        rotationMatrix.set(quat4dPose);
        Matrix4d transformMatrix = new Matrix4d();
        transformMatrix.setIdentity();
        transformMatrix.set(rotationMatrix);
        transformMatrix.setM03(rosPose.getPosition().getX());
        transformMatrix.setM13(rosPose.getPosition().getY());
        transformMatrix.setM23(rosPose.getPosition().getZ());
        transformMatrix.setM33(1.0);
        Matrix4x4 pose = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(transformMatrix);
        return pose;
    }

    public static Matrix4x4 rosPoseToMatrix(PoseStamped rosPoseStamped) {
        return GeometryUtils.rosPoseToMatrix(rosPoseStamped.getPose());
    }

    public static Pose matrixToRosPose(Matrix4x4 pose, ROSNode node) {
        Pose rosPose = (Pose)node.newFromType("geometry_msgs/Pose");
        Quat4d quat4dPose = new Quat4d();
        Matrix3d matrix3dPose = new Matrix3d();
        matrix3dPose.setM00(pose.getM00());
        matrix3dPose.setM01(pose.getM01());
        matrix3dPose.setM02(pose.getM02());
        matrix3dPose.setM10(pose.getM10());
        matrix3dPose.setM11(pose.getM11());
        matrix3dPose.setM12(pose.getM12());
        matrix3dPose.setM20(pose.getM20());
        matrix3dPose.setM21(pose.getM21());
        matrix3dPose.setM22(pose.getM22());
        quat4dPose.set(matrix3dPose);
        rosPose.getOrientation().setX(quat4dPose.getX());
        rosPose.getOrientation().setY(quat4dPose.getY());
        rosPose.getOrientation().setZ(quat4dPose.getZ());
        rosPose.getOrientation().setW(quat4dPose.getW());
        rosPose.getPosition().setX(pose.getM03());
        rosPose.getPosition().setY(pose.getM13());
        rosPose.getPosition().setZ(pose.getM23());
        return rosPose;
    }

    public static Matrix4x4 createPositionMatrix(double x, double y, double z) {
        Matrix4x4 pose = ApogyCommonMathFactory.eINSTANCE.createMatrix4x4();
        pose.setM03(x);
        pose.setM13(y);
        pose.setM23(z);
        return pose;
    }
}

