/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.utilities;

import org.eclipse.apogy.addons.ros.messages.ROSFrameworkLogEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.ros.node.ConnectedNode;

public class FrameworkLogUtils {
    public static ROSFrameworkLogEntry convertToROSFrameworkLogEntry(IStatus status, ConnectedNode connectedNode) {
        ROSFrameworkLogEntry entry = (ROSFrameworkLogEntry)connectedNode.getTopicMessageFactory().newFromType("org.eclipse.apogy.addons.ros.messages/ROSFrameworkLogEntry");
        entry.setBundleName(status.getPlugin());
        entry.setMessage(status.getMessage());
        byte severity = (byte)status.getSeverity();
        entry.setSeverity(severity);
        if (status.getException() != null) {
            entry.setThrowableMessage(status.getException().getMessage());
        }
        return entry;
    }

    public static ROSFrameworkLogEntry convertToROSFrameworkLogEntry(FrameworkLogEntry frameworkLogEntry, ConnectedNode connectedNode) {
        ROSFrameworkLogEntry entry = (ROSFrameworkLogEntry)connectedNode.getTopicMessageFactory().newFromType("org.eclipse.apogy.addons.ros.messages/ROSFrameworkLogEntry");
        entry.setBundleName(frameworkLogEntry.getEntry());
        entry.setMessage(frameworkLogEntry.getMessage());
        byte severity = (byte)frameworkLogEntry.getSeverity();
        entry.setSeverity(severity);
        if (frameworkLogEntry.getThrowable() != null) {
            entry.setThrowableMessage(frameworkLogEntry.getThrowable().getMessage());
        }
        return entry;
    }

    public static FrameworkLogEntry convertToFrameworkLogEntry(String messagePrefix, ROSFrameworkLogEntry rosFrameworkLogEntry) {
        String bundleName = rosFrameworkLogEntry.getBundleName();
        byte severity = rosFrameworkLogEntry.getSeverity();
        String fullMessage = rosFrameworkLogEntry.getMessage();
        if (messagePrefix != null) {
            fullMessage = String.valueOf(messagePrefix) + fullMessage;
        }
        Throwable throwable = null;
        if (rosFrameworkLogEntry.getThrowableMessage() != null && rosFrameworkLogEntry.getThrowableMessage().length() > 0) {
            throwable = new Throwable(rosFrameworkLogEntry.getThrowableMessage());
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry(bundleName, (int)severity, 0, fullMessage, 0, throwable, null);
        return frameworkLogEntry;
    }
}

