/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.impl.TimeDifferenceValueSourceImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TimeDifferenceValueSourceCustomImpl
extends TimeDifferenceValueSourceImpl {
    private Job job = null;

    @Override
    public void initialise() {
        super.initialise();
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.getJob().schedule();
    }

    @Override
    public void setUpdatePeriod(long newUpdatePeriod) {
        if (newUpdatePeriod >= 0L) {
            super.setUpdatePeriod(newUpdatePeriod);
        }
    }

    @Override
    public void dispose() {
        this.getJob().cancel();
        this.job = null;
        super.dispose();
    }

    @Override
    public EObject getEObject() {
        return this;
    }

    @Override
    public EStructuralFeature getFeature() {
        return ApogyAddonsMonitoringPackage.Literals.TIME_DIFFERENCE_VALUE_SOURCE__TIME_DIFFERENCE;
    }

    @Override
    public void valueChanged(Long oldValue, Long newValue) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE__CURRENT_VALUE, (Object)new Long(newValue), true);
    }

    private Job getJob() {
        if (this.job == null) {
            this.job = new Job("Time Difference Value Source"){

                protected IStatus run(IProgressMonitor progressMonitor) {
                    while (!progressMonitor.isCanceled()) {
                        long now = System.currentTimeMillis();
                        long timeToDate = TimeDifferenceValueSourceCustomImpl.this.getDate().getTime() - now;
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimeDifferenceValueSourceCustomImpl.this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.TIME_DIFFERENCE_VALUE_SOURCE__TIME_DIFFERENCE, (Object)new Long(timeToDate), true);
                        if (progressMonitor.isCanceled()) continue;
                        try {
                            Thread.sleep(TimeDifferenceValueSourceCustomImpl.this.getUpdatePeriod());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.job;
    }
}

