/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.impl.SoundNotificationEffectImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundNotificationEffectCustomImpl
extends SoundNotificationEffectImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SoundNotificationEffectCustomImpl.class);
    protected URL internalURL = null;
    protected Clip clip = null;
    protected FloatControl volumeControl = null;
    protected boolean activated = false;

    @Override
    public void activate(ApogyNotifier notifier, Object newValue) {
        this.activated = true;
        if (this.clip != null && this.clip.isRunning()) {
            this.stopClip();
        }
        this.startClip();
    }

    @Override
    public void deactivate() {
        if (this.isInterruptible()) {
            this.activated = false;
            if (this.clip != null) {
                try {
                    this.clip.stop();
                    this.clip.close();
                    this.clip = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.clip != null) {
            this.activated = false;
            this.clip.loop(0);
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        super.setEnabled(newEnabled);
        if (!newEnabled) {
            this.stopClip();
        } else if (this.activated) {
            this.startClip();
        }
    }

    @Override
    public void setRepeat(boolean newRepeat) {
        super.setRepeat(newRepeat);
        if (this.activated && this.isEnabled()) {
            this.stopClip();
            this.startClip();
        }
    }

    @Override
    public void dispose() {
        this.activated = false;
        this.deactivate();
        this.stopClip();
    }

    @Override
    public void setSoundURL(String newSoundURL) {
        super.setSoundURL(newSoundURL);
        this.internalURL = null;
    }

    @Override
    public void setVolume(float newVolume) {
        if (newVolume >= 0.0f && newVolume <= 100.0f) {
            super.setVolume(newVolume);
            if (this.volumeControl != null) {
                try {
                    this.volumeControl.setValue(this.getMasterGain(newVolume));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void startClip() {
        Job job = new Job("Play Sound."){

            protected IStatus run(IProgressMonitor arg0) {
                try {
                    URL url = SoundNotificationEffectCustomImpl.this.resolveSoundURL();
                    if (url != null) {
                        AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
                        SoundNotificationEffectCustomImpl.this.clip = AudioSystem.getClip();
                        SoundNotificationEffectCustomImpl.this.clip.open(audioIn);
                        if (SoundNotificationEffectCustomImpl.this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                            SoundNotificationEffectCustomImpl.this.volumeControl = (FloatControl)SoundNotificationEffectCustomImpl.this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                            float gain = SoundNotificationEffectCustomImpl.this.getMasterGain(SoundNotificationEffectCustomImpl.this.getVolume());
                            SoundNotificationEffectCustomImpl.this.volumeControl.setValue(gain);
                        }
                        if (SoundNotificationEffectCustomImpl.this.isRepeat()) {
                            SoundNotificationEffectCustomImpl.this.clip.setLoopPoints(0, -1);
                            SoundNotificationEffectCustomImpl.this.clip.loop(-1);
                        }
                        final CountDownLatch doneLatch = new CountDownLatch(1);
                        SoundNotificationEffectCustomImpl.this.clip.addLineListener(new LineListener(){

                            @Override
                            public void update(LineEvent event) {
                                if (event.getType().equals(LineEvent.Type.STOP)) {
                                    doneLatch.countDown();
                                    if ((this).SoundNotificationEffectCustomImpl.this.clip != null) {
                                        (this).SoundNotificationEffectCustomImpl.this.clip.close();
                                    }
                                }
                            }
                        });
                        SoundNotificationEffectCustomImpl.this.clip.start();
                        doneLatch.await();
                    }
                }
                catch (FileNotFoundException e) {
                    final String title = "Sound Alarm Effect failed to activate !";
                    final String message = "Failed to open sound file <" + SoundNotificationEffectCustomImpl.this.getSoundURL() + "> !";
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, message, 1, new String[]{"OK"}, 0);
                            dialog.open();
                        }
                    });
                    Logger.error(message, (Throwable)e);
                }
                catch (Exception e) {
                    final String title = "Sound Alarm Effect failed to activate !";
                    final String message = "Failed to play sound file <" + SoundNotificationEffectCustomImpl.this.getSoundURL() + "> : " + e.getMessage();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, message, 1, new String[]{"OK"}, 0);
                            dialog.open();
                        }
                    });
                    Logger.error(message, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void stopClip() {
        if (this.clip != null) {
            try {
                this.clip.stop();
                this.clip = null;
            }
            catch (Exception e) {
                Logger.error("Failed to stop clip!", (Throwable)e);
            }
        }
    }

    protected URL resolveSoundURL() {
        if (this.internalURL == null) {
            try {
                this.internalURL = new URL(this.getSoundURL());
            }
            catch (Exception e) {
                this.internalURL = null;
                String message = "Failed to open sound file <" + this.getSoundURL() + "> : " + e.getMessage();
                Logger.error(message, (Throwable)e);
            }
        }
        return this.internalURL;
    }

    protected float getMasterGain(float volume) {
        if (this.volumeControl != null) {
            float max = this.volumeControl.getMaximum();
            float min = this.volumeControl.getMinimum();
            float gain = (float)(20.0 * Math.log(this.getVolume() / 100.0f));
            if (gain < min) {
                gain = min;
            }
            if (gain > max) {
                gain = max;
            }
            return gain;
        }
        return 0.0f;
    }
}

