/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.Constants;
import org.eclipse.apogy.addons.sensors.imaging.camera.URLImageOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.wizards.AbstractOverlayWizardPage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class URLImageOverlayWizardPage
extends AbstractOverlayWizardPage<URLImageOverlay, URLImageOverlay, URLImageOverlay> {
    public static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.URLImageOverlayWizardPage";
    private URLSelectionComposite urlSelectionComposite;
    private ImageDisplayComposite imageDisplayComposite;
    private Adapter imageAdapter;

    public URLImageOverlayWizardPage(String id, URLImageOverlay rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id, rootEObject, featurePath, eStructuralFeature);
    }

    @Override
    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Group detailsGroup = new Group(top, 0);
        detailsGroup.setLayout((Layout)new GridLayout(1, false));
        detailsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        detailsGroup.setText("Overlay's Parameters");
        this.settingsComposite = this.createEmptySettingsComposite((Composite)detailsGroup, 0);
        ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.settingsComposite, this.getResolvedEObject());
        this.settingsComposite.layout();
        Group urlGroup = new Group(top, 0);
        urlGroup.setLayout((Layout)new GridLayout(1, false));
        urlGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        urlGroup.setText("Image URL");
        this.urlSelectionComposite = new URLSelectionComposite((Composite)urlGroup, 0){

            protected void urlStringSelected(String newURLString) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet(URLImageOverlayWizardPage.this.getResolvedEObject(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.URL_IMAGE_OVERLAY__URL, (Object)newURLString, true);
                URLImageOverlayWizardPage.this.validate();
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Group grpImagePreview = new Group(top, 2048);
        grpImagePreview.setText("Image Preview");
        grpImagePreview.setLayout((Layout)new GridLayout(1, false));
        grpImagePreview.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)grpImagePreview, 0);
        this.imageDisplayComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.setRootEObject((EObject)((URLImageOverlay)this.getRootEObject()));
        this.setControl((Control)top);
    }

    @Override
    protected void rootEObjectChanged(URLImageOverlay rootEObject) {
        ImageData imageData;
        ((URLImageOverlay)this.getResolvedEObject()).eAdapters().remove((Object)this.getImageAdapter());
        super.rootEObjectChanged(rootEObject);
        if (this.getResolvedEObject() != null) {
            ((URLImageOverlay)this.getResolvedEObject()).eAdapters().add((Object)this.getImageAdapter());
        }
        if (rootEObject != null && rootEObject.getImage() != null && this.imageDisplayComposite != null && (imageData = EImagesUtilities.INSTANCE.convertToImageData(rootEObject.getImage().asBufferedImage())) != null) {
            this.imageDisplayComposite.setImageData(imageData);
        }
    }

    @Override
    protected void validate() {
        this.setErrorMessage(null);
        if (((URLImageOverlay)this.getResolvedEObject()).getUrl() == null) {
            this.setErrorMessage("No image URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    @Override
    protected URI getDetailsViewModelURI() {
        return Constants.URL_IMAGE_OVERLAY_SETTINGS_VIEW_MODEL_URI;
    }

    private Adapter getImageAdapter() {
        if (this.imageAdapter == null) {
            this.imageAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof URLImageOverlay && (featureId = msg.getFeatureID(URLImageOverlay.class)) == 7) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(((URLImageOverlay)URLImageOverlayWizardPage.this.getResolvedEObject()).getImage().asBufferedImage());
                                if (imageData != null) {
                                    URLImageOverlayWizardPage.this.imageDisplayComposite.setImageData(imageData);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.imageAdapter;
    }
}

