/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlayList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraTool;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraToolList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.FilterList;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFilter;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.listeners.AbstractVariableFeatureReferenceListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraViewConfigurationListener {
    private static final Logger Logger = LoggerFactory.getLogger(CameraViewConfigurationListener.class);
    private AbstractVariableFeatureReferenceListener abstractVariableFeatureReferenceListener = null;
    private final List<EObject> observedEObjects = new ArrayList<EObject>();
    private Adapter adapter;
    private CameraViewConfiguration cameraViewConfiguration;

    public CameraViewConfigurationListener(CameraViewConfiguration newCameraViewConfiguration) {
        this.setCameraViewConfiguration(newCameraViewConfiguration);
    }

    public CameraViewConfiguration getCameraViewConfiguration() {
        return this.cameraViewConfiguration;
    }

    public void setCameraViewConfiguration(CameraViewConfiguration newCameraViewConfiguration) {
        for (EObject obj : this.observedEObjects) {
            obj.eAdapters().remove((Object)this.getAdapter());
        }
        this.observedEObjects.clear();
        this.cameraViewConfiguration = newCameraViewConfiguration;
        if (newCameraViewConfiguration != null) {
            newCameraViewConfiguration.eAdapters().add((Object)this.getAdapter());
            newCameraViewConfiguration.getFilterList().eAdapters().add((Object)this.getAdapter());
            this.observedEObjects.add(newCameraViewConfiguration.getFilterList());
            for (ImageFilter filter : newCameraViewConfiguration.getFilterList().getImageFilters()) {
                filter.eAdapters().add((Object)this.getAdapter());
                this.observedEObjects.add((EObject)filter);
            }
            newCameraViewConfiguration.getOverlayList().eAdapters().add((Object)this.getAdapter());
            this.observedEObjects.add(newCameraViewConfiguration.getOverlayList());
            for (CameraOverlay overlay : newCameraViewConfiguration.getOverlayList().getOverlays()) {
                overlay.eAdapters().add((Object)this.getAdapter());
                this.observedEObjects.add((EObject)overlay);
                if (overlay == null) continue;
                overlay.eAdapters().add((Object)this.getAdapter());
                this.observedEObjects.add((EObject)overlay);
            }
            newCameraViewConfiguration.getToolList().eAdapters().add((Object)this.getAdapter());
            this.observedEObjects.add(newCameraViewConfiguration.getToolList());
            for (CameraTool cameraTool : newCameraViewConfiguration.getToolList().getTools()) {
                cameraTool.eAdapters().add((Object)this.getAdapter());
                this.observedEObjects.add((EObject)cameraTool);
            }
        }
    }

    protected void cameraChanged(AbstractCamera newCamera) {
    }

    protected void displayRectifiedChanged(boolean newRectified) {
    }

    protected void imageSizeChanged(int newImageWidth, int newImageHeigh) {
    }

    protected void imageFiltersChanged() {
    }

    protected void overlaysChanged() {
    }

    protected void toolsChanged() {
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    block64: {
                        block65: {
                            if (!(msg.getNotifier() instanceof CameraViewConfiguration)) break block65;
                            CameraViewConfiguration cameraViewConfiguration = (CameraViewConfiguration)msg.getNotifier();
                            int featureID = msg.getFeatureID(CameraViewConfiguration.class);
                            switch (featureID) {
                                case 8: 
                                case 9: {
                                    CameraViewConfigurationListener.this.imageSizeChanged(cameraViewConfiguration.getImageWidth(), cameraViewConfiguration.getImageHeight());
                                    break;
                                }
                                case 7: {
                                    CameraViewConfigurationListener.this.cameraChanged((AbstractCamera)msg.getNewValue());
                                    break;
                                }
                                case 11: {
                                    CameraViewConfigurationListener.this.displayRectifiedChanged(msg.getNewBooleanValue());
                                    break;
                                }
                                case 1: {
                                    if (msg.getOldValue() instanceof Variable) {
                                        CameraViewConfigurationListener.this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference(null);
                                    }
                                    if (msg.getNewValue() instanceof Variable) {
                                        CameraViewConfigurationListener.this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference((VariableFeatureReference)cameraViewConfiguration);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block64;
                        }
                        if (msg.getNotifier() instanceof FilterList) {
                            CameraViewConfigurationListener.this.imageFiltersChanged();
                            if (msg.getEventType() == 3) {
                                if (msg.getNewValue() instanceof ImageFilter) {
                                    ImageFilter newFilter = (ImageFilter)msg.getNewValue();
                                    newFilter.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.add(newFilter);
                                }
                            } else if (msg.getEventType() == 5) {
                                try {
                                    List newFilters = (List)msg.getNewValue();
                                    for (ImageFilter filter : newFilters) {
                                        filter.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.add(filter);
                                    }
                                }
                                catch (Exception exception) {}
                            } else if (msg.getEventType() == 4) {
                                if (msg.getOldValue() instanceof ImageFilter) {
                                    ImageFilter oldFilter = (ImageFilter)msg.getOldValue();
                                    oldFilter.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.remove(oldFilter);
                                }
                            } else if (msg.getEventType() == 6) {
                                try {
                                    List oldFilters = (List)msg.getOldValue();
                                    for (ImageFilter filter : oldFilters) {
                                        filter.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.remove(filter);
                                        CameraViewConfigurationListener.this.observedEObjects.remove(filter);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        } else if (msg.getNotifier() instanceof ImageFilter) {
                            CameraViewConfigurationListener.this.imageFiltersChanged();
                        } else if (msg.getNotifier() instanceof CameraOverlayList) {
                            CameraViewConfigurationListener.this.overlaysChanged();
                            if (msg.getEventType() == 3) {
                                if (msg.getNewValue() instanceof CameraOverlay) {
                                    CameraOverlay newCameraOverlay = (CameraOverlay)msg.getNewValue();
                                    newCameraOverlay.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.add(newCameraOverlay);
                                }
                            } else if (msg.getEventType() == 5) {
                                try {
                                    List newCameraOverlays = (List)msg.getNewValue();
                                    for (CameraOverlay newCameraOverlay : newCameraOverlays) {
                                        newCameraOverlay.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.add(newCameraOverlay);
                                    }
                                }
                                catch (Exception exception) {}
                            } else if (msg.getEventType() == 4) {
                                if (msg.getOldValue() instanceof CameraOverlay) {
                                    CameraOverlay oldCameraOverlay = (CameraOverlay)msg.getOldValue();
                                    oldCameraOverlay.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.remove(oldCameraOverlay);
                                }
                            } else if (msg.getEventType() == 6) {
                                try {
                                    List oldCameraOverlays = (List)msg.getOldValue();
                                    for (CameraOverlay cameraOverlays : oldCameraOverlays) {
                                        cameraOverlays.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.remove(cameraOverlays);
                                        CameraViewConfigurationListener.this.observedEObjects.remove(cameraOverlays);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        } else if (msg.getNotifier() instanceof CameraOverlay) {
                            CameraViewConfigurationListener.this.overlaysChanged();
                        } else if (msg.getNotifier() instanceof CameraToolList) {
                            CameraViewConfigurationListener.this.toolsChanged();
                            if (msg.getEventType() == 3) {
                                if (msg.getNewValue() instanceof CameraTool) {
                                    CameraTool newCameraTool = (CameraTool)msg.getNewValue();
                                    newCameraTool.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.add(newCameraTool);
                                }
                            } else if (msg.getEventType() == 5) {
                                try {
                                    List newCameraTools = (List)msg.getNewValue();
                                    for (CameraTool newCameraTool : newCameraTools) {
                                        newCameraTool.eAdapters().add((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.add(newCameraTool);
                                    }
                                }
                                catch (Exception exception) {}
                            } else if (msg.getEventType() == 4) {
                                if (msg.getOldValue() instanceof CameraTool) {
                                    CameraTool oldCameraTool = (CameraTool)msg.getOldValue();
                                    oldCameraTool.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                    CameraViewConfigurationListener.this.observedEObjects.remove(oldCameraTool);
                                }
                            } else if (msg.getEventType() == 6) {
                                try {
                                    List oldCameraTools = (List)msg.getOldValue();
                                    for (CameraTool cameraTool : oldCameraTools) {
                                        cameraTool.eAdapters().remove((Object)CameraViewConfigurationListener.this.getAdapter());
                                        CameraViewConfigurationListener.this.observedEObjects.remove(cameraTool);
                                        CameraViewConfigurationListener.this.observedEObjects.remove(cameraTool);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        } else if (msg.getNotifier() instanceof CameraTool) {
                            CameraViewConfigurationListener.this.toolsChanged();
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    private AbstractVariableFeatureReferenceListener getAbstractVariableFeatureReferenceListener() {
        if (this.abstractVariableFeatureReferenceListener == null) {
            this.abstractVariableFeatureReferenceListener = new AbstractVariableFeatureReferenceListener(this.cameraViewConfiguration){

                protected void instanceChanged(EObject oldInstance, EObject newInstance) {
                    if (oldInstance != null || newInstance != null) {
                        CameraViewConfigurationListener.this.cameraChanged(CameraViewConfigurationListener.this.resolveCamera());
                    }
                }
            };
        }
        return this.abstractVariableFeatureReferenceListener;
    }

    private AbstractCamera resolveCamera() {
        AbstractCamera cam = null;
        try {
            EObject instance = ApogyCoreInvocatorFacade.INSTANCE.getInstance((VariableFeatureReference)this.cameraViewConfiguration);
            if (instance instanceof AbstractCamera) {
                cam = (AbstractCamera)instance;
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to resolve camera.", t);
        }
        return cam;
    }
}

