/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FontNameComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, String> {
    protected ComboViewer fontComboViewer;
    protected Combo fontCombo;

    public FontNameComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.fontComboViewer = new ComboViewer(top, 0);
        this.fontCombo = this.fontComboViewer.getCombo();
        GridData gd_fontCombo = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_fontCombo.widthHint = 250;
        gd_fontCombo.minimumWidth = 250;
        this.fontCombo.setLayoutData((Object)gd_fontCombo);
        this.fontComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fontComboViewer.setInput(this.getAvailableFonts());
        this.fontComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection iStructuredSelection;
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof String) {
                    String fontName = (String)iStructuredSelection.getFirstElement();
                    FontNameComposite.this.fontSelected(fontName);
                }
            }
        });
        return top;
    }

    protected void rootEObjectChanged(RootEObject rootObject) {
        String fontName;
        if (rootObject != null && this.getResolvedEObject() != null && (fontName = (String)this.getResolvedEObject().eGet(this.getEStructuralFeature())) != null && this.fontComboViewer != null) {
            this.fontComboViewer.setSelection((ISelection)new StructuredSelection((Object)fontName));
        }
    }

    protected void fontSelected(String fontName) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getResolvedEObject(), this.getEStructuralFeature(), (Object)fontName, true);
    }

    protected List<String> getAvailableFonts() {
        ArrayList<String> fonts = new ArrayList<String>();
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontNames.length) {
            fonts.add(fontNames[i]);
            ++i;
        }
        return fonts;
    }
}

