/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OverlayAlignment implements Enumerator
{
    CENTER(1, "CENTER", "Center"),
    LOWER_LEFT_CORNER(2, "LOWER_LEFT_CORNER", "Lower Left"),
    UPPER_LEFT_CORNER(3, "UPPER_LEFT_CORNER", "Upper Left"),
    LOWER_RIGHT_CORNER(4, "LOWER_RIGHT_CORNER", "Lower Right"),
    UPPER_RIGHT_CORNER(5, "UPPER_RIGHT_CORNER", "Upper Right");

    public static final int CENTER_VALUE = 1;
    public static final int LOWER_LEFT_CORNER_VALUE = 2;
    public static final int UPPER_LEFT_CORNER_VALUE = 3;
    public static final int LOWER_RIGHT_CORNER_VALUE = 4;
    public static final int UPPER_RIGHT_CORNER_VALUE = 5;
    private static final OverlayAlignment[] VALUES_ARRAY;
    public static final List<OverlayAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OverlayAlignment[]{CENTER, LOWER_LEFT_CORNER, UPPER_LEFT_CORNER, LOWER_RIGHT_CORNER, UPPER_RIGHT_CORNER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OverlayAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OverlayAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OverlayAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OverlayAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OverlayAlignment get(int value) {
        switch (value) {
            case 1: {
                return CENTER;
            }
            case 2: {
                return LOWER_LEFT_CORNER;
            }
            case 3: {
                return UPPER_LEFT_CORNER;
            }
            case 4: {
                return LOWER_RIGHT_CORNER;
            }
            case 5: {
                return UPPER_RIGHT_CORNER;
            }
        }
        return null;
    }

    private OverlayAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

