/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SwitchState implements Enumerator
{
    ON(0, "ON", "On"),
    OFF(1, "OFF", "Off");

    public static final int ON_VALUE = 0;
    public static final int OFF_VALUE = 1;
    private static final SwitchState[] VALUES_ARRAY;
    public static final List<SwitchState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SwitchState[]{ON, OFF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SwitchState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SwitchState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SwitchState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SwitchState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SwitchState get(int value) {
        switch (value) {
            case 0: {
                return ON;
            }
            case 1: {
                return OFF;
            }
        }
        return null;
    }

    private SwitchState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

