/*
 * Decompiled with CFR 0.152.
 */
package edu.wlu.cs.levy.CG;

import edu.wlu.cs.levy.CG.HPoint;
import edu.wlu.cs.levy.CG.HRect;
import edu.wlu.cs.levy.CG.KDNode;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeyMissingException;
import edu.wlu.cs.levy.CG.KeySizeException;
import edu.wlu.cs.levy.CG.NearestNeighborList;
import java.util.Vector;

public class KDTree {
    private int m_K;
    private KDNode m_root;
    private int m_count;

    public KDTree(int k) {
        this.m_K = k;
        this.m_root = null;
    }

    public void insert(double[] key, Object value) throws KeySizeException, KeyDuplicateException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        this.m_root = KDNode.ins(new HPoint(key), value, this.m_root, 0, this.m_K);
        ++this.m_count;
    }

    public Object search(double[] key) throws KeySizeException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode kd = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        return kd == null ? null : kd.v;
    }

    public void delete(double[] key) throws KeySizeException, KeyMissingException {
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode t = KDNode.srch(new HPoint(key), this.m_root, this.m_K);
        if (t == null) {
            throw new KeyMissingException();
        }
        t.deleted = true;
        --this.m_count;
    }

    public Object nearest(double[] key) throws KeySizeException {
        Object[] nbrs = this.nearest(key, 1);
        return nbrs[0];
    }

    public Object[] nearest(double[] key, int n) throws KeySizeException, IllegalArgumentException {
        if (n < 0 || n > this.m_count) {
            throw new IllegalArgumentException("Number of neighbors cannot be negative or greater than number of nodes");
        }
        if (key.length != this.m_K) {
            throw new KeySizeException();
        }
        Object[] nbrs = new Object[n];
        NearestNeighborList nnl = new NearestNeighborList(n);
        HRect hr = HRect.infiniteHRect(key.length);
        double max_dist_sqd = Double.MAX_VALUE;
        HPoint keyp = new HPoint(key);
        KDNode.nnbr(this.m_root, keyp, hr, max_dist_sqd, 0, this.m_K, nnl);
        int i = 0;
        while (i < n) {
            KDNode kd = (KDNode)nnl.removeHighest();
            nbrs[n - i - 1] = kd.v;
            ++i;
        }
        return nbrs;
    }

    public Object[] range(double[] lowk, double[] uppk) throws KeySizeException {
        if (lowk.length != uppk.length) {
            throw new KeySizeException();
        }
        if (lowk.length != this.m_K) {
            throw new KeySizeException();
        }
        Vector v = new Vector();
        KDNode.rsearch(new HPoint(lowk), new HPoint(uppk), this.m_root, 0, this.m_K, v);
        Object[] o = new Object[v.size()];
        int i = 0;
        while (i < v.size()) {
            KDNode n = (KDNode)v.elementAt(i);
            o[i] = n.v;
            ++i;
        }
        return o;
    }

    public String toString() {
        return this.m_root.toString(0);
    }
}

