/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.URLEImage;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ShaderBasedProjectedImageMeshTool;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShaderBasedProjectedImageMeshToolImageURLWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.ShaderBasedProjectedImageMeshToolImageURLWizardPage";
    private final ShaderBasedProjectedImageMeshTool tool;
    private URLSelectionComposite urlSelectionComposite;
    private String urlString = null;

    public ShaderBasedProjectedImageMeshToolImageURLWizardPage(ShaderBasedProjectedImageMeshTool shaderBasedProjectedImageMeshTool) {
        super(WIZARD_PAGE_ID);
        this.tool = shaderBasedProjectedImageMeshTool;
        if (shaderBasedProjectedImageMeshTool != null && shaderBasedProjectedImageMeshTool.getImage() instanceof URLEImage) {
            URLEImage urleImage = (URLEImage)shaderBasedProjectedImageMeshTool.getImage();
            this.urlString = urleImage.getUrl();
        }
        this.setTitle("Shader Based Projected Image Mesh Tool : Image URL selection");
        this.setDescription("Sets the Image URL.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.urlSelectionComposite = new URLSelectionComposite(container, 0, new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                ShaderBasedProjectedImageMeshToolImageURLWizardPage.this.urlString = newURLString;
                ShaderBasedProjectedImageMeshToolImageURLWizardPage.this.validate();
                URLEImage urleImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
                urleImage.setUrl(newURLString);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ShaderBasedProjectedImageMeshToolImageURLWizardPage.this.tool, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_BASED_SHADER_BASED_MESH_TOOL__IMAGE, (Object)urleImage, true);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.tool != null && this.tool.getImage() instanceof URLEImage) {
            URLEImage urleImage = (URLEImage)this.tool.getImage();
            this.urlSelectionComposite.setUrlString(urleImage.getUrl());
        }
        this.setControl((Control)container);
        this.urlSelectionComposite.setFocus();
    }

    protected void validate() {
        boolean urlValid = this.urlString != null && this.urlString.length() > 0;
        this.setPageComplete(urlValid);
        if (urlValid) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage("Invalid URL specified !");
        }
    }
}

