/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshTool;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class ShaderBasedMeshToolAlphaComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends AbstractEObjectComposite<RootEObject, ResolvedEObject, Float> {
    private Scale scale;
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");

    public ShaderBasedMeshToolAlphaComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.scale = new Scale(top, 2048);
        this.scale.setMaximum(100);
        this.scale.setPageIncrement(1);
        GridData gd_scale = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_scale.widthHint = 250;
        gd_scale.minimumWidth = 250;
        this.scale.setLayoutData((Object)gd_scale);
        this.scale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                float alpha = (float)ShaderBasedMeshToolAlphaComposite.this.scale.getSelection() / 100.0f;
                ShaderBasedMeshToolAlphaComposite.this.alphaSelected(alpha);
                ShaderBasedMeshToolAlphaComposite.this.scale.setToolTipText(ShaderBasedMeshToolAlphaComposite.this.decimalFormat.format(alpha));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return top;
    }

    protected void rootEObjectChanged(RootEObject rootObject) {
        if (rootObject != null && this.getResolvedEObject() != null) {
            ShaderBasedMeshTool tool = (ShaderBasedMeshTool)rootObject;
            float alpha = tool.getAlpha();
            int selection = Math.round(alpha * 100.0f);
            this.scale.setSelection(selection);
            this.scale.setToolTipText(this.decimalFormat.format(alpha));
        }
    }

    protected void alphaSelected(float alpha) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getResolvedEObject(), this.getEStructuralFeature(), (Object)Float.valueOf(alpha), true);
    }
}

