/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshToolType;
import org.eclipse.apogy.core.environment.surface.impl.ShaderBasedBullseyeToolImpl;

public class ShaderBasedBullseyeToolCustomImpl
extends ShaderBasedBullseyeToolImpl {
    public static final int TOOL_CIRCLE_COLOR_RED_INDEX = 3;
    public static final int TOOL_CIRCLE_COLOR_GREEN_INDEX = 4;
    public static final int TOOL_CIRCLE_COLOR_BLUE_INDEX = 5;
    public static final int TOOL_RADIUS_INTERVAL_INDEX = 6;
    public static final int TOOL_MAXIMUM_RADIUS_INDEX = 7;
    public static final int TOOL_CIRCLE_LINE_WIDTH_INDEX = 8;

    @Override
    public ShaderBasedMeshToolType getToolType() {
        return ShaderBasedMeshToolType.BULLSEYE;
    }

    @Override
    public void setCircleRadiusInterval(float newCircleRadiusInterval) {
        super.setCircleRadiusInterval(Math.abs(newCircleRadiusInterval));
    }

    @Override
    public float[] createShaderParameters() {
        float[] parameters = super.createShaderParameters();
        parameters[6] = Math.abs(this.getCircleRadiusInterval());
        parameters[7] = Math.abs(this.getMaximumRadius());
        parameters[8] = Math.abs(this.getCircleLineWidth());
        parameters[3] = new Float((float)this.getCircleColor().rgb.red / 255.0f).floatValue();
        parameters[4] = new Float((float)this.getCircleColor().rgb.green / 255.0f).floatValue();
        parameters[5] = new Float((float)this.getCircleColor().rgb.blue / 255.0f).floatValue();
        return parameters;
    }
}

