/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import edu.wlu.cs.levy.CG.KDTree;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshDerivedImageMapLayerCustomImpl;
import org.eclipse.apogy.core.environment.surface.impl.FixedPositionLineOfSightImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedPositionLineOfSightImageMapLayerCustomImpl
extends FixedPositionLineOfSightImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(FixedPositionLineOfSightImageMapLayerImpl.class);
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        CartesianTriangularMesh mesh;
        if (this.getCartesianTriangularMeshMapLayer() != null && (mesh = this.getCartesianTriangularMeshMapLayer().getCurrentMesh()) != null) {
            SubMonitor subMonitor = null;
            subMonitor = this.isUseHeightPerpendicularToGround() ? SubMonitor.convert((IProgressMonitor)progressMonitor, (int)6) : SubMonitor.convert((IProgressMonitor)progressMonitor, (int)4);
            long startTime = System.currentTimeMillis();
            RectangularVolumeRegion meshRegion = this.getRectangularVolumeRegion();
            if (meshRegion.getXDimension() > 0.0 && meshRegion.getYDimension() > 0.0) {
                progressMonitor.subTask("Generating pixel locations");
                Point3d[][] pixelsLocation = this.getPixelsLocation(this.getCartesianTriangularMeshMapLayer().getCurrentMesh(), (IProgressMonitor)subMonitor.newChild(1));
                progressMonitor.worked(1);
                int numberPixelAlongX = pixelsLocation.length;
                int numberPixelAlongY = pixelsLocation[0].length;
                double xIncrement = meshRegion.getXDimension() / (double)numberPixelAlongX;
                double yIncrement = meshRegion.getYDimension() / (double)numberPixelAlongY;
                double averagingRadius = Math.sqrt(xIncrement * xIncrement + yIncrement * yIncrement);
                progressMonitor.subTask("Create KD tree");
                KDTree kdTree = this.createTriangleKDTree(mesh, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.worked(1);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                progressMonitor.subTask("Find pixel intersection");
                this.pixelsIntersectionPoints = this.getPixelsIntersectionPoints(pixelsLocation, mesh, kdTree, averagingRadius, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.worked(1);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                this.lineOfSights = null;
                if (this.isUseHeightPerpendicularToGround()) {
                    CartesianTriangle[][] pixelsIntersectionTriangles = this.getPixelsIntersectionTriangle(pixelsLocation, mesh, kdTree, averagingRadius, progressMonitor);
                    subMonitor.worked(1);
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    this.pixelNormals = this.getNormals(pixelsLocation, pixelsIntersectionTriangles, mesh, kdTree, averagingRadius, progressMonitor);
                    subMonitor.worked(1);
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    this.lineOfSights = this.getLineOfSights(this.pixelsIntersectionPoints, this.pixelNormals, mesh, this.getObserverPosition(), this.getTargetHeightAboveGround(), kdTree, progressMonitor);
                    progressMonitor.worked(1);
                } else {
                    progressMonitor.subTask("Find line of sight");
                    this.lineOfSights = this.getLineOfSights(this.pixelsIntersectionPoints, mesh, this.getObserverPosition(), this.getTargetHeightAboveGround(), kdTree, progressMonitor);
                    progressMonitor.worked(1);
                }
                if (progressMonitor.isCanceled()) {
                    return;
                }
                int[][] pixelColors = this.getPixelsColor(this.lineOfSights);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                AbstractEImage image = this.convertToImage(pixelColors, (IProgressMonitor)subMonitor.newChild(1));
                long endTime = System.currentTimeMillis();
                double duration = (double)(endTime - startTime) * 0.001;
                Logger.info("Updated image in <" + this.decimalFormat.format(duration) + "> seconds.");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)image, true);
            }
        }
    }

    protected short[][] getLineOfSights(Point3d[][] pixelsIntersectionPoints, CartesianTriangularMesh mesh, org.eclipse.apogy.common.math.Tuple3d observerPose, double targetHeightAboveGround, KDTree kdTree, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding line of sights.");
        Logger.info("getLineOfSights() starts.");
        long startTime = System.currentTimeMillis();
        int numberPixelAlongX = pixelsIntersectionPoints.length;
        int numberPixelAlongY = pixelsIntersectionPoints[0].length;
        short[][] lineOfSights = new short[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetLineOfSight";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "Get Line Of Sight (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetLineOfSightsJob(jobName, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, mesh, lineOfSights, kdTree).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {}
        progressMonitor.done();
        long endTime = System.currentTimeMillis();
        double duration = (double)(endTime - startTime) * 0.001;
        DecimalFormat format = new DecimalFormat("0.00");
        Logger.info("getLineOfSights() completed in <" + format.format(duration) + "> seconds.");
        return lineOfSights;
    }

    protected short[][] getLineOfSights(Point3d[][] pixelsIntersectionPoints, Vector3d[][] pixelsNormals, CartesianTriangularMesh mesh, org.eclipse.apogy.common.math.Tuple3d observerPose, double targetHeightAboveGround, KDTree kdTree, IProgressMonitor progressMonitor) {
        progressMonitor.subTask("Finding line of sights Perpendicular to Ground.");
        long startTime = System.currentTimeMillis();
        int numberPixelAlongX = pixelsNormals.length;
        int numberPixelAlongY = pixelsNormals[0].length;
        short[][] lineOfSights = new short[numberPixelAlongX][numberPixelAlongY];
        int numberOfJobs = this.getNumberOfProcessorToUse();
        int xIndexSlotSize = Math.floorDiv(numberPixelAlongX, numberOfJobs);
        int xStartIndex = 0;
        int xEndIndex = xIndexSlotSize;
        String family = "GetLineOfSightJob";
        int jobNumber = 0;
        while (jobNumber < numberOfJobs) {
            String jobName = "Get Line Of Sight (" + Integer.toString(jobNumber + 1) + " of " + numberOfJobs + ") [" + xStartIndex + " ," + xEndIndex + "]";
            new GetLineOfSightsPerpendicularToGroundJob(jobName, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, pixelsNormals, mesh, lineOfSights, kdTree).schedule();
            xEndIndex = (xStartIndex += xIndexSlotSize + 1) + xIndexSlotSize;
            if (xEndIndex >= numberPixelAlongX) {
                xEndIndex = numberPixelAlongX - 1;
            }
            ++jobNumber;
        }
        try {
            IJobManager manager = Job.getJobManager();
            manager.join((Object)family, progressMonitor);
        }
        catch (Exception exception) {}
        progressMonitor.done();
        long endTime = System.currentTimeMillis();
        double duration = (double)(endTime - startTime) * 0.001;
        DecimalFormat format = new DecimalFormat("0.00");
        Logger.info("getLineOfSights() completed in <" + format.format(duration) + "> seconds.");
        return lineOfSights;
    }

    @Override
    protected int[][] getPixelsColor(short[][] lineOfSights) {
        int numberPixelAlongX = lineOfSights.length;
        int numberPixelAlongY = lineOfSights[0].length;
        int lineOfSightRGB = this.getLineOfSightColor();
        int noLineOfSightRGB = this.noLineOfSightColor();
        int[][] pixelColors = new int[numberPixelAlongX][numberPixelAlongY];
        int i = 0;
        while (i < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                short data = lineOfSights[i][j];
                switch (data) {
                    case 2: {
                        pixelColors[i][j] = lineOfSightRGB;
                        break;
                    }
                    case 1: {
                        pixelColors[i][j] = noLineOfSightRGB;
                        break;
                    }
                    case 0: {
                        pixelColors[i][j] = -1;
                    }
                }
                ++j;
            }
            ++i;
        }
        return pixelColors;
    }

    protected int getLineOfSightColor() {
        return this.convertColor(this.getLineOfSightAvailableColor());
    }

    protected int noLineOfSightColor() {
        return this.convertColor(this.getLineOfSightNotAvailableColor());
    }

    protected abstract class AbstractGetLineOfSightsJob
    extends CartesianTriangularMeshDerivedImageMapLayerCustomImpl.ProcessPixelArrayJob<short[][]> {
        protected Point3d[][] pixelsIntersectionPoints;
        protected short[][] lineOfSights;
        protected KDTree kdTree;
        protected CartesianTriangularMesh mesh;

        public AbstractGetLineOfSightsJob(String name, String family, int xStartIndex, int xEndIndex, Point3d[][] pixelsIntersectionPoints, CartesianTriangularMesh mesh, short[][] lineOfSights, KDTree kdTree) {
            super(FixedPositionLineOfSightImageMapLayerCustomImpl.this, name, family, xStartIndex, xEndIndex, mesh, null);
            this.pixelsIntersectionPoints = pixelsIntersectionPoints;
            this.lineOfSights = lineOfSights;
            this.numberOfTicks = xEndIndex - xStartIndex;
            this.kdTree = kdTree;
            this.mesh = mesh;
        }

        @Override
        public short[][] getOutput() {
            return this.lineOfSights;
        }

        protected abstract Vector3d getTargetPosition(int var1, int var2);

        protected Set<CartesianTriangle> getTrianglesApplicableToLOS() {
            double tmp;
            HashSet<CartesianTriangle> triangles = null;
            Vector3d observerPosition = new Vector3d(FixedPositionLineOfSightImageMapLayerCustomImpl.this.getObserverPosition().asTuple3d());
            Point3d regionMin = new Point3d();
            Point3d regionMax = new Point3d();
            this.getExtent(this.pixelsIntersectionPoints, this.xStartIndex, this.xEndIndex, regionMin, regionMax);
            double xMin = regionMin.x;
            double yMin = regionMin.y;
            double xMax = observerPosition.x;
            double yMax = regionMax.y;
            if (xMin > xMax) {
                tmp = xMin;
                xMin = xMax;
                xMax = tmp;
            }
            if (yMin > yMax) {
                tmp = yMin;
                yMin = yMax;
                yMax = tmp;
            }
            double[] from = new double[]{xMin, yMin};
            double[] to = new double[]{xMax, yMax};
            try {
                Object[] tmp2 = this.kdTree.range(from, to);
                triangles = new HashSet<CartesianTriangle>();
                int t = 0;
                while (t < tmp2.length) {
                    if (tmp2[t] instanceof List) {
                        List list = (List)tmp2[t];
                        triangles.addAll(list);
                    }
                    ++t;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                triangles = new HashSet(this.mesh.getPolygons());
            }
            return triangles;
        }

        protected Point3d getIntersection(Vector3d observerPosition, Vector3d target, CartesianTriangle triangle) {
            if (((CartesianPositionCoordinates)triangle.getVertices().get(0)).getZ() < observerPosition.z && ((CartesianPositionCoordinates)triangle.getVertices().get(1)).getZ() < observerPosition.z && ((CartesianPositionCoordinates)triangle.getVertices().get(2)).getZ() < observerPosition.z && ((CartesianPositionCoordinates)triangle.getVertices().get(0)).getZ() < target.z && ((CartesianPositionCoordinates)triangle.getVertices().get(1)).getZ() < target.z && ((CartesianPositionCoordinates)triangle.getVertices().get(2)).getZ() < target.z) {
                return null;
            }
            return Geometry3DUtilities.getLineAndPolygonIntersectionPoint((Vector3d)observerPosition, (Vector3d)target, (CartesianPolygon)triangle);
        }

        protected CartesianTriangle getNextTriangleTowardToLocation(Vector3d from, Vector3d to, Set<CartesianTriangle> neighbours, List<CartesianTriangle> previouslyUsed) {
            CartesianTriangle result = null;
            CartesianPositionCoordinates p1 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(from.x, from.y, from.z);
            CartesianPositionCoordinates p2 = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(to.x, to.y, to.z);
            double distance = Double.POSITIVE_INFINITY;
            for (CartesianTriangle triangle : neighbours) {
                CartesianPositionCoordinates point;
                double d;
                if (previouslyUsed.contains(triangle) || !Geometry3DUtilities.isLineIntersectsPolygon((CartesianPlane)CartesianPlane.XY, (CartesianPositionCoordinates)p1, (CartesianPositionCoordinates)p2, (CartesianPolygon)triangle) || !((d = Geometry3DUtilities.getPointToLineDistance((CartesianPositionCoordinates)(point = triangle.getCentroid()), (CartesianPositionCoordinates)p1, (CartesianPositionCoordinates)p2)) < distance)) continue;
                distance = d;
                result = triangle;
            }
            return result;
        }

        protected void getExtent(Point3d[][] pixelsIntersectionPoints, int xStartIndex, int xEndIndex, Point3d min, Point3d max) {
            min.x = Double.POSITIVE_INFINITY;
            min.y = Double.POSITIVE_INFINITY;
            max.x = Double.NEGATIVE_INFINITY;
            max.y = Double.NEGATIVE_INFINITY;
            int yLenght = pixelsIntersectionPoints[0].length;
            int i = xStartIndex;
            while (i < xEndIndex) {
                int j = 0;
                while (j < yLenght) {
                    Point3d point = pixelsIntersectionPoints[i][j];
                    if (point != null) {
                        if (point.x < min.x) {
                            min.x = point.x;
                        }
                        if (point.y < min.y) {
                            min.y = point.y;
                        }
                        if (point.x > max.x) {
                            max.x = point.x;
                        }
                        if (point.y > max.y) {
                            max.y = point.y;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }

        protected IStatus computeLineOfSight(IProgressMonitor monitor, boolean useTriangleCorridors) {
            Vector3d observerPosition = new Vector3d(FixedPositionLineOfSightImageMapLayerCustomImpl.this.getObserverPosition().asTuple3d());
            int numberPixelAlongY = this.pixelsIntersectionPoints[0].length;
            if (!useTriangleCorridors) {
                Point3d positionOnSurface = null;
                Point3d intersection = null;
                Set<CartesianTriangle> triangles = this.getTrianglesApplicableToLOS();
                int i = this.xStartIndex;
                while (i <= this.xEndIndex) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    int j = 0;
                    while (j < numberPixelAlongY) {
                        intersection = null;
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        positionOnSurface = this.pixelsIntersectionPoints[i][j];
                        if (positionOnSurface != null) {
                            Vector3d target = this.getTargetPosition(i, j);
                            Iterator<CartesianTriangle> it = triangles.iterator();
                            while (intersection == null && it.hasNext()) {
                                intersection = Geometry3DUtilities.getLineAndPolygonIntersectionPoint((Vector3d)observerPosition, (Vector3d)target, (CartesianPolygon)((CartesianPolygon)it.next()));
                            }
                            this.lineOfSights[i][j] = intersection == null ? 2 : 1;
                        } else {
                            this.lineOfSights[i][j] = 0;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                ArrayList<CartesianTriangle> tested = new ArrayList<CartesianTriangle>();
                CartesianTriangle triangle = null;
                HashSet<CartesianTriangle> neighbours = new HashSet<CartesianTriangle>();
                Point3d positionOnSurface = null;
                Point3d intersection = null;
                int i = this.xStartIndex;
                while (i <= this.xEndIndex) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    int j = 0;
                    while (j < numberPixelAlongY) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        tested.clear();
                        positionOnSurface = this.pixelsIntersectionPoints[i][j];
                        if (positionOnSurface != null) {
                            Vector3d target = this.getTargetPosition(i, j);
                            try {
                                Point3d point = new Point3d((Tuple3d)target);
                                List<CartesianTriangle> neigours = FixedPositionLineOfSightImageMapLayerCustomImpl.this.findClosestTriangles(this.kdTree, point);
                                Iterator<CartesianTriangle> it = neigours.iterator();
                                while (it.hasNext() && triangle == null) {
                                    CartesianTriangle t = it.next();
                                    if (Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)CartesianAxis.Z, (Point3d)point, (CartesianPolygon)t) == null) continue;
                                    triangle = t;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            intersection = null;
                            Vector3d fromV = new Vector3d(positionOnSurface.x, positionOnSurface.y, 0.0);
                            Vector3d toV = new Vector3d(observerPosition.x, observerPosition.y, 0.0);
                            while (intersection == null && triangle != null) {
                                intersection = this.getIntersection(observerPosition, target, triangle);
                                if (intersection != null) continue;
                                tested.add(triangle);
                                neighbours.clear();
                                neighbours.addAll((Collection<CartesianTriangle>)this.mesh.getPolygonsSharingPoint((Coordinates)((CartesianPositionCoordinates)triangle.getVertices().get(0))));
                                neighbours.addAll((Collection<CartesianTriangle>)this.mesh.getPolygonsSharingPoint((Coordinates)((CartesianPositionCoordinates)triangle.getVertices().get(1))));
                                neighbours.addAll((Collection<CartesianTriangle>)this.mesh.getPolygonsSharingPoint((Coordinates)((CartesianPositionCoordinates)triangle.getVertices().get(2))));
                                triangle = this.getNextTriangleTowardToLocation(fromV, toV, neighbours, tested);
                            }
                            this.lineOfSights[i][j] = intersection == null ? 2 : 1;
                        } else {
                            this.lineOfSights[i][j] = 0;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }
    }

    protected class GetLineOfSightsJob
    extends AbstractGetLineOfSightsJob {
        public GetLineOfSightsJob(String name, String family, int xStartIndex, int xEndIndex, Point3d[][] pixelsIntersectionPoints, CartesianTriangularMesh mesh, short[][] lineOfSights, KDTree kdTree) {
            super(name, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, mesh, lineOfSights, kdTree);
        }

        @Override
        protected Vector3d getTargetPosition(int i, int j) {
            Point3d positionOnSurface = this.pixelsIntersectionPoints[i][j];
            return new Vector3d(positionOnSurface.x, positionOnSurface.y, positionOnSurface.z + FixedPositionLineOfSightImageMapLayerCustomImpl.this.getTargetHeightAboveGround());
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            String name = "Get Line Of Sight [" + this.xStartIndex + "," + this.xEndIndex + "]";
            subMonitor.beginTask(name, this.numberOfTicks);
            this.computeLineOfSight((IProgressMonitor)subMonitor, true);
            return Status.OK_STATUS;
        }

        @Override
        public short[][] getOutput() {
            return this.lineOfSights;
        }
    }

    protected class GetLineOfSightsPerpendicularToGroundJob
    extends AbstractGetLineOfSightsJob {
        protected Vector3d[][] pixelsNormals;

        public GetLineOfSightsPerpendicularToGroundJob(String name, String family, int xStartIndex, int xEndIndex, Point3d[][] pixelsIntersectionPoints, Vector3d[][] pixelsNormals, CartesianTriangularMesh mesh, short[][] lineOfSights, KDTree kdTree) {
            super(name, family, xStartIndex, xEndIndex, pixelsIntersectionPoints, mesh, lineOfSights, kdTree);
            this.pixelsNormals = pixelsNormals;
        }

        @Override
        protected Vector3d getTargetPosition(int i, int j) {
            Point3d positionOnSurface = this.pixelsIntersectionPoints[i][j];
            Vector3d target = new Vector3d(positionOnSurface.x, positionOnSurface.y, positionOnSurface.z);
            Vector3d antennaPosition = new Vector3d(this.pixelsNormals[i][j]);
            antennaPosition.scale(FixedPositionLineOfSightImageMapLayerCustomImpl.this.getTargetHeightAboveGround());
            target.add((Tuple3d)antennaPosition);
            return target;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getNumberOfTicks());
            subMonitor.beginTask("Get Line Of Sight Perpendicular To Ground", this.numberOfTicks);
            this.computeLineOfSight((IProgressMonitor)subMonitor, false);
            return Status.OK_STATUS;
        }

        @Override
        public short[][] getOutput() {
            return this.lineOfSights;
        }
    }
}

