/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.listeners;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.TypeMemberReferenceListElement;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AbstractVariableFeatureReferenceListener {
    protected VariableFeatureReference variableFeatureReference;
    private Adapter variableFeatureReferenceAdapter;
    private Adapter contextAdapter;
    private Adapter environmentAdapter;
    private ValueAdapter valueAdapter = null;
    private EObject previousInstance;
    private TypeApiAdapter previousTypeApiAdapterInstance;

    public AbstractVariableFeatureReferenceListener(VariableFeatureReference variableFeatureReference) {
        this.setVariableFeatureReference(variableFeatureReference);
    }

    public void setVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        if (this.variableFeatureReference != null) {
            this.unRegisterFrom(this.variableFeatureReference, this.getVariableFeatureReferenceAdapter());
        }
        this.variableFeatureReference = newVariableFeatureReference;
        if (newVariableFeatureReference != null) {
            this.registerTo(this.variableFeatureReference, this.getVariableFeatureReferenceAdapter());
        }
        this.update();
    }

    protected void contextChanged(Context oldContext, Context newContext) {
    }

    protected void instanceChanged(EObject oldInstance, EObject newInstance) {
    }

    protected void typeApiAdapterChanged(TypeApiAdapter oldTypeApiAdapter, TypeApiAdapter newTypeApiAdapter) {
    }

    protected void variableChanged(Variable oldVariable, Variable newVariable) {
    }

    protected void valueChanged(Object oldValue, Object newValue) {
    }

    protected void listRootNodeChanged() {
    }

    private void updateInstance(EObject newInstance) {
        if (this.previousInstance != newInstance) {
            this.instanceChanged(this.previousInstance, newInstance);
            if (this.previousInstance != null) {
                this.getValueAdapter().setInstance(null);
            }
            if (newInstance != null) {
                this.getValueAdapter().setInstance(newInstance);
            }
        }
        this.previousInstance = newInstance;
    }

    private void updateTypeApiAdapter(TypeApiAdapter newTypeApiAdapter) {
        if (this.previousTypeApiAdapterInstance != newTypeApiAdapter) {
            this.typeApiAdapterChanged(this.previousTypeApiAdapterInstance, newTypeApiAdapter);
            this.previousTypeApiAdapterInstance = newTypeApiAdapter;
        }
    }

    private void update() {
        try {
            if (this.variableFeatureReference != null) {
                EObject newInstance = ApogyCoreInvocatorFacade.INSTANCE.getInstance(this.variableFeatureReference);
                this.updateInstance(newInstance);
                TypeApiAdapter newTypeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(this.variableFeatureReference);
                this.updateTypeApiAdapter(newTypeApiAdapter);
            } else {
                this.updateInstance(null);
                this.updateTypeApiAdapter(null);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void registerTo(VariableFeatureReference variableFeatureReference, Adapter adapter) {
        if (variableFeatureReference != null) {
            variableFeatureReference.eAdapters().add((Object)adapter);
            if (variableFeatureReference.getVariable() != null) {
                this.registerTo(variableFeatureReference.getVariable(), adapter);
            }
            if (variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                this.registerTo(variableFeatureReference.getTypeMemberReferenceListElement(), adapter);
            }
        }
    }

    protected void unRegisterFrom(VariableFeatureReference variableFeatureReference, Adapter adapter) {
        if (variableFeatureReference != null) {
            variableFeatureReference.eAdapters().remove((Object)adapter);
            if (variableFeatureReference.getVariable() != null) {
                this.unRegisterFrom(variableFeatureReference.getVariable(), adapter);
            }
            if (variableFeatureReference.getTypeMemberReferenceListElement() != null) {
                this.unRegisterFrom(variableFeatureReference.getTypeMemberReferenceListElement(), adapter);
            }
        }
    }

    protected void registerTo(Variable variable, Adapter adapter) {
        if (variable != null) {
            variable.eAdapters().add((Object)adapter);
            if (variable.getEnvironment() != null) {
                this.registerTo(variable.getEnvironment());
            }
        }
    }

    protected void unRegisterFrom(Variable variable, Adapter adapter) {
        if (variable != null) {
            variable.eAdapters().remove((Object)adapter);
            if (variable.getEnvironment() != null) {
                this.unRegisterFrom(variable.getEnvironment());
            }
        }
    }

    protected void registerTo(Environment environment) {
        if (environment != null) {
            environment.eAdapters().add((Object)this.getEnvironmentAdapter());
            if (environment.getActiveContext() != null) {
                this.registerTo(environment.getActiveContext());
            }
        }
    }

    protected void unRegisterFrom(Environment environment) {
        if (environment != null) {
            environment.eAdapters().remove((Object)this.getEnvironmentAdapter());
            if (environment.getActiveContext() != null) {
                this.unRegisterFrom(environment.getActiveContext());
            }
        }
    }

    protected void registerTo(Context context) {
        if (context != null) {
            context.eAdapters().add((Object)this.getContextAdapter());
        }
    }

    protected void unRegisterFrom(Context context) {
        if (context != null) {
            context.eAdapters().remove((Object)this.getContextAdapter());
        }
    }

    protected void registerTo(TypeMemberReferenceListElement typeMemberReferenceListElement, Adapter adapter) {
        if (typeMemberReferenceListElement != null) {
            typeMemberReferenceListElement.eAdapters().add((Object)adapter);
            TypeMemberReferenceListElement child = typeMemberReferenceListElement.getChild();
            while (child != null) {
                child.eAdapters().add((Object)adapter);
                child = child.getChild();
            }
        }
    }

    protected void unRegisterFrom(TypeMemberReferenceListElement typeMemberReferenceListElement, Adapter adapter) {
        if (typeMemberReferenceListElement != null) {
            typeMemberReferenceListElement.eAdapters().remove((Object)adapter);
            TypeMemberReferenceListElement child = typeMemberReferenceListElement.getChild();
            while (child != null) {
                child.eAdapters().remove((Object)adapter);
                child = child.getChild();
            }
        }
    }

    private Adapter getContextAdapter() {
        if (this.contextAdapter == null) {
            this.contextAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(Context.class) == 6) {
                        AbstractVariableFeatureReferenceListener.this.update();
                    } else if (msg.getFeatureID(Context.class) == 7) {
                        AbstractVariableFeatureReferenceListener.this.update();
                    }
                }
            };
        }
        return this.contextAdapter;
    }

    private Adapter getEnvironmentAdapter() {
        if (this.environmentAdapter == null) {
            this.environmentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(Environment.class) == 6) {
                        Context oldContext = null;
                        Context newContext = null;
                        if (msg.getOldValue() instanceof Context) {
                            oldContext = (Context)msg.getOldValue();
                            oldContext.eAdapters().remove((Object)AbstractVariableFeatureReferenceListener.this.getContextAdapter());
                        }
                        AbstractVariableFeatureReferenceListener.this.update();
                        if (msg.getNewValue() instanceof Context) {
                            newContext = (Context)msg.getNewValue();
                            newContext.eAdapters().add((Object)AbstractVariableFeatureReferenceListener.this.getContextAdapter());
                        }
                        AbstractVariableFeatureReferenceListener.this.contextChanged(oldContext, newContext);
                    }
                }
            };
        }
        return this.environmentAdapter;
    }

    private Adapter getVariableFeatureReferenceAdapter() {
        if (this.variableFeatureReferenceAdapter == null) {
            this.variableFeatureReferenceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof VariableFeatureReference) {
                        int featureId = msg.getFeatureID(VariableFeatureReference.class);
                        switch (featureId) {
                            case 3: {
                                EObject newInstance = ApogyCoreInvocatorFacade.INSTANCE.getInstance(AbstractVariableFeatureReferenceListener.this.variableFeatureReference);
                                AbstractVariableFeatureReferenceListener.this.updateInstance(newInstance);
                                break;
                            }
                            case 2: {
                                AbstractVariableFeatureReferenceListener.this.unRegisterFrom((TypeMemberReferenceListElement)msg.getOldValue(), (Adapter)this);
                                AbstractVariableFeatureReferenceListener.this.registerTo((TypeMemberReferenceListElement)msg.getNewValue(), (Adapter)this);
                                TypeApiAdapter newTypeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(AbstractVariableFeatureReferenceListener.this.variableFeatureReference);
                                AbstractVariableFeatureReferenceListener.this.updateTypeApiAdapter(newTypeApiAdapter);
                                break;
                            }
                            case 1: {
                                Variable oldVariable = null;
                                Variable newVariable = null;
                                if (msg.getOldValue() instanceof Variable) {
                                    oldVariable = (Variable)msg.getOldValue();
                                }
                                if (msg.getNewValue() instanceof Variable) {
                                    newVariable = (Variable)msg.getNewValue();
                                }
                                AbstractVariableFeatureReferenceListener.this.variableChanged(oldVariable, newVariable);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.variableFeatureReferenceAdapter;
    }

    private ValueAdapter getValueAdapter() {
        if (this.valueAdapter == null) {
            this.valueAdapter = new ValueAdapter();
        }
        return this.valueAdapter;
    }

    public class ValueAdapter
    extends AdapterImpl {
        private Map<EStructuralFeature, Object> featureToObjectMap = new HashMap<EStructuralFeature, Object>();
        private EObject instance = null;

        public void dispose() {
            if (this.instance != null) {
                this.unregisterFromEObject(this.instance);
            }
            this.featureToObjectMap.clear();
        }

        public void setInstance(EObject eObject) {
            if (this.instance != null) {
                this.unregisterFromEObject(eObject);
            }
            this.instance = eObject;
            if (eObject != null) {
                this.registerToEObject(eObject);
            }
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (AbstractVariableFeatureReferenceListener.this.variableFeatureReference != null && AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath() != null) {
                if (this.isNotificationApplicable(AbstractVariableFeatureReferenceListener.this.variableFeatureReference, notification)) {
                    Object newValue;
                    Object oldValue = notification.getOldValue();
                    if (oldValue != (newValue = notification.getNewValue())) {
                        AbstractVariableFeatureReferenceListener.this.valueChanged(oldValue, newValue);
                    }
                } else if (notification.getFeature() instanceof EStructuralFeature) {
                    EObject notifier = (EObject)notification.getNotifier();
                    EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                    if (this.featureToObjectMap.containsKey(feature)) {
                        Object oldObject = this.featureToObjectMap.get(feature);
                        if (oldObject instanceof EObject) {
                            ((EObject)oldObject).eAdapters().remove((Object)this);
                        }
                        Object newObject = notifier.eGet(feature, true);
                        this.featureToObjectMap.put(feature, newObject);
                        if (newObject instanceof EObject) {
                            ((EObject)newObject).eAdapters().add((Object)this);
                        }
                    }
                }
            }
        }

        protected void populateMap() {
            int i = 0;
            while (i < AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath().length) {
                EStructuralFeature feature = AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath()[i];
                this.featureToObjectMap.put(feature, null);
                ++i;
            }
        }

        protected EStructuralFeature getLastFeature() {
            if (AbstractVariableFeatureReferenceListener.this.variableFeatureReference != null && AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath() != null && AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath().length > 0) {
                return AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath()[AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath().length - 1];
            }
            return null;
        }

        protected void unregisterFromEObject(EObject eObject) {
            eObject.eAdapters().remove((Object)this);
            for (EStructuralFeature feature : this.featureToObjectMap.keySet()) {
                Object obj = this.featureToObjectMap.get(feature);
                if (!(obj instanceof EObject)) continue;
                ((EObject)obj).eAdapters().remove((Object)this);
            }
            this.featureToObjectMap.clear();
        }

        protected void registerToEObject(EObject eObject) {
            if (AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath().length > 0) {
                this.populateMap();
                Object parent = eObject;
                int i = 0;
                while (i < AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath().length && parent != null) {
                    parent.eAdapters().add((Object)this);
                    EStructuralFeature feature = AbstractVariableFeatureReferenceListener.this.variableFeatureReference.getFeaturePath().getFeaturePath()[i];
                    this.featureToObjectMap.put(feature, parent);
                    Object next = parent.eGet(feature, true);
                    parent = next instanceof EObject ? (EObject)next : null;
                    ++i;
                }
            }
        }

        protected boolean isNotificationApplicable(VariableFeatureReference variableFeatureReference, Notification notification) {
            if (notification.getNotifier() instanceof EObject && notification.getFeature() instanceof EStructuralFeature && variableFeatureReference.getFeaturePath().getFeaturePath().length > 0) {
                EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                return feature == this.getLastFeature();
            }
            return false;
        }
    }
}

