/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.impl.TypesRegistryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesRegistryCustomImpl
extends TypesRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TypesRegistryImpl.class);

    @Override
    public EList<Type> getTypes() {
        if (this.types == null) {
            this.types = super.getTypes();
            ArrayList<Type> list = new ArrayList<Type>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getTYPE_CONTRIBUTOR_EXTENSION_POINT_ID());
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                String uri_str = contributor.getAttribute(this.getTYPE_CONTRIBUTOR_URI_ID());
                URI typeURI = URI.createURI((String)("platform:/plugin/" + contributor.getNamespaceIdentifier() + "/" + uri_str), (boolean)true);
                try {
                    TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
                    Resource resource = domain.getResourceSet().getResource(typeURI, true);
                    resource.load(Collections.EMPTY_MAP);
                    EObject content = (EObject)resource.getContents().get(0);
                    if (content instanceof Type) {
                        Type ss = (Type)content;
                        list.add(ss);
                    } else {
                        Logger.error(String.valueOf(typeURI.toString()) + " does not contain a valide Apogy Type/System model.");
                    }
                }
                catch (Throwable throwable) {
                    Logger.error("Unable to load " + typeURI.toString() + ".");
                }
                ++i;
            }
            this.types.addAll(list);
        }
        return this.types;
    }
}

