/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.converters.AbstractFileExporter;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.invocator.AttributeResultValue;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.ReferenceResultValue;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;

public class OperationCallResultFileExporter
extends AbstractFileExporter {
    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return OperationCallResult.class;
    }

    public boolean canConvert(Object input) {
        return input instanceof OperationCallResult;
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        OperationCallResult operationCallResult = (OperationCallResult)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)this.getMetaData(operationCallResult));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains("metadata")) {
            return "The OperationCallResult metadata (Description, Variable, Operation Call, Parameters, time stamp).";
        }
        return null;
    }

    public String getMetaData(Object input) {
        if (input instanceof OperationCallResult) {
            return this.getMetaData((OperationCallResult)input);
        }
        return null;
    }

    public String getMetaData(OperationCallResult operationCallResult) {
        AbstractOperationCall abstractOperationCall;
        String metadata = "";
        if (operationCallResult.getDescription() != null) {
            metadata = String.valueOf(metadata) + "Description = " + operationCallResult.getDescription().replace("\n", ";") + "\n";
        }
        if (operationCallResult.getTime() != null) {
            metadata = String.valueOf(metadata) + "Time = " + ApogyCommonEMFFacade.INSTANCE.format(operationCallResult.getTime()) + "\n";
        }
        if ((abstractOperationCall = operationCallResult.getOperationCall()) != null) {
            String exceptionString;
            String resultString;
            if (abstractOperationCall.getVariable() != null) {
                String str = ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString(abstractOperationCall);
                str = str.contains("#") ? str.substring(0, str.indexOf("#")) : str;
                metadata = String.valueOf(metadata) + "Variable = " + str + "\n";
            }
            if (abstractOperationCall.getEOperation() != null) {
                metadata = String.valueOf(metadata) + "Operation = " + abstractOperationCall.getEOperation().getName() + "(";
                ArgumentsList argumentList = abstractOperationCall.getArgumentsList();
                EOperation eOperation = abstractOperationCall.getEOperation();
                if (!abstractOperationCall.getEOperation().getEParameters().isEmpty()) {
                    String eParamatersString = "";
                    if (argumentList != null) {
                        List<?> argumentValues = argumentList.getArgumentValues();
                        int index = 0;
                        while (index < argumentList.getArguments().size()) {
                            EParameter eParameter = (EParameter)eOperation.getEParameters().get(index);
                            Object value = argumentValues.get(index);
                            eParamatersString = String.valueOf(eParamatersString) + OperationCallResultFileExporter.getParameterValue(eParameter, value) + " ";
                            eParamatersString = String.valueOf(eParamatersString) + ", ";
                            ++index;
                        }
                        eParamatersString = eParamatersString.substring(0, eParamatersString.length() - 2);
                    }
                    metadata = String.valueOf(metadata) + eParamatersString;
                }
                metadata = String.valueOf(metadata) + ")\n";
            }
            if ((resultString = OperationCallResultFileExporter.getReturnValueString(operationCallResult)) != null) {
                metadata = String.valueOf(metadata) + "Return = " + resultString + "\n";
            }
            if ((exceptionString = OperationCallResultFileExporter.getExceptionString(operationCallResult)) != null) {
                metadata = String.valueOf(metadata) + "Exception = " + exceptionString + "\n";
            }
        }
        return metadata;
    }

    private static String getParameterValue(EParameter eParameter, Object value) {
        String valueString = "";
        if (value == null) {
            value = "null";
        } else if (value instanceof Number) {
            Number number = (Number)value;
            valueString = Double.toString(number.doubleValue());
        } else {
            valueString = value.toString();
            if (valueString.length() > 50) {
                valueString = valueString.substring(0, 49);
            }
        }
        return valueString;
    }

    private static String getReturnValueString(OperationCallResult operationCallResult) {
        if (operationCallResult.getResultValue() == null) {
            return null;
        }
        if (operationCallResult.getResultValue() instanceof AttributeResultValue) {
            AttributeResultValue attributeResultValue = (AttributeResultValue)operationCallResult.getResultValue();
            if (attributeResultValue.getValue().getObject() != null) {
                return attributeResultValue.getValue().getObject().toString();
            }
            return "null";
        }
        if (operationCallResult.getResultValue() instanceof ReferenceResultValue) {
            ReferenceResultValue referenceResultValue = (ReferenceResultValue)operationCallResult.getResultValue();
            if (referenceResultValue.getValue() != null) {
                return referenceResultValue.getValue().toString();
            }
            return "null";
        }
        return null;
    }

    private static String getExceptionString(OperationCallResult operationCallResult) {
        if (operationCallResult.getExceptionContainer() != null && operationCallResult.getExceptionContainer().getException() != null) {
            return operationCallResult.getExceptionContainer().getException().getMessage();
        }
        return null;
    }
}

