/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.ui.wizards.ExportToFileWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportFileDestinationWizardPage
extends WizardPage {
    private final ExportToFileWizard wizard;
    private String filePath = null;
    private String defaultFileName;
    private Composite container;
    private Text txtPath;

    public ExportFileDestinationWizardPage(String pageName, IFileExporter iFileExporter, ExportToFileWizard wizard) {
        super(pageName);
        this.setDescription("Select the destination for the export.");
        this.wizard = wizard;
    }

    public ExportFileDestinationWizardPage(String pageName, IFileExporter iFileExporter, ExportToFileWizard wizard, String defaultFileName) {
        super(pageName);
        this.setDescription("Select the destination for the export.");
        this.wizard = wizard;
        this.defaultFileName = defaultFileName;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.container.setLayout((Layout)layout);
        Label lblPath = new Label(this.container, 0);
        lblPath.setText("Destination Path :");
        GridData gd_lblPath = new GridData(16384, 0x1000000, false, false);
        lblPath.setLayoutData((Object)gd_lblPath);
        this.txtPath = new Text(this.container, 2048);
        GridData gd_txtPath = new GridData(4, 0x1000000, true, false, 1, 3);
        this.txtPath.setLayoutData((Object)gd_txtPath);
        Button btnSelect = new Button(this.container, 8);
        btnSelect.setText("Select...");
        GridData btnSelectGridData = new GridData(16384, 0x1000000, false, false);
        btnSelect.setLayoutData((Object)btnSelectGridData);
        btnSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String currentDir = System.getProperty("user.dir");
                FileDialog fileChooser = new FileDialog(ExportFileDestinationWizardPage.this.container.getShell(), 8192);
                fileChooser.setText("Select a file:");
                fileChooser.setFilterPath(currentDir);
                String[] extensions = this.getFileExtensions();
                if (extensions == null || extensions.length == 0) {
                    extensions = new String[]{"*.*"};
                }
                fileChooser.setFilterExtensions(this.getFileExtensions());
                if (ExportFileDestinationWizardPage.this.defaultFileName != null && ExportFileDestinationWizardPage.this.defaultFileName.length() > 0) {
                    fileChooser.setFileName(ExportFileDestinationWizardPage.this.defaultFileName);
                }
                ExportFileDestinationWizardPage.this.filePath = fileChooser.open();
                if (ExportFileDestinationWizardPage.this.filePath != null) {
                    int index = ExportFileDestinationWizardPage.this.filePath.lastIndexOf(".");
                    if (index > 0) {
                        ExportFileDestinationWizardPage.this.filePath = ExportFileDestinationWizardPage.this.filePath.substring(0, index);
                    }
                    ExportFileDestinationWizardPage.this.txtPath.setText(ExportFileDestinationWizardPage.this.filePath);
                } else {
                    ExportFileDestinationWizardPage.this.txtPath.setText("");
                }
                if (ExportFileDestinationWizardPage.this.filePath != null && ExportFileDestinationWizardPage.this.filePath.length() > 0) {
                    ExportFileDestinationWizardPage.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            private String[] getFileExtensions() {
                List<String> requestedFileExtension = ExportFileDestinationWizardPage.this.wizard.getRequestedExtensions();
                if (requestedFileExtension.isEmpty()) {
                    return new String[0];
                }
                String[] extensions = new String[requestedFileExtension.size()];
                Iterator<String> it = requestedFileExtension.iterator();
                int i = 0;
                while (it.hasNext()) {
                    String s = it.next();
                    s.trim();
                    extensions[i] = "*." + s;
                    ++i;
                }
                return extensions;
            }
        });
        this.setControl((Control)this.container);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isPageComplete() {
        return this.filePath != null && this.filePath.length() > 0;
    }
}

