/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.ui.composites;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersGraphsFacade;
import org.eclipse.apogy.common.converters.ConverterEdge;
import org.eclipse.apogy.common.converters.ui.composites.ConvertersUIConstants;
import org.eclipse.apogy.common.converters.ui.utils.FullyQualifiedTypesNameComparator;
import org.eclipse.apogy.common.converters.ui.utils.ShortTypesNameComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class AvailableConversionComposite
extends Composite {
    private org.eclipse.swt.widgets.List inputTypesList = null;
    private org.eclipse.swt.widgets.List outputTypesList = null;
    private ConvertersUIConstants.ClassNameDisplayMode classNameDisplayMode = ConvertersUIConstants.ClassNameDisplayMode.SIMPLE_CLASS_NAME;
    private SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> convertersGraph = null;
    private Map<Class<?>, List<Class<?>>> conversionsMap = null;
    private List<Class<?>> inputTypesClassList = null;

    public AvailableConversionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public AvailableConversionComposite(Composite parent, int style, SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> convertersGraph) {
        super(parent, style);
        this.inputTypesList = this.createInputTypesList();
        this.outputTypesList = new org.eclipse.swt.widgets.List((Composite)this, 2816);
        this.outputTypesList.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.setConvertersGraph(convertersGraph);
    }

    public ConvertersUIConstants.ClassNameDisplayMode getClassNameDisplayMode() {
        return this.classNameDisplayMode;
    }

    public void setClassNameDisplayMode(ConvertersUIConstants.ClassNameDisplayMode classNameDisplayMode) {
        this.classNameDisplayMode = classNameDisplayMode;
        this.populateInputTypesList();
        this.updateOutputTypesList(this.inputTypesClassList.get(this.inputTypesList.getSelectionIndex()));
    }

    public SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> getConvertersGraph() {
        return this.convertersGraph;
    }

    public void setConvertersGraph(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> convertersGraph) {
        this.convertersGraph = convertersGraph;
        this.conversionsMap = ApogyCommonConvertersGraphsFacade.INSTANCE.getAvailableDestinationTypeMap(convertersGraph);
        this.populateInputTypesList();
    }

    private org.eclipse.swt.widgets.List createInputTypesList() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblInputTypes = new Label((Composite)this, 0);
        lblInputTypes.setText("Input Types");
        Label lblOutputTypes = new Label((Composite)this, 0);
        lblOutputTypes.setText("Output Types");
        final org.eclipse.swt.widgets.List inputTypesList = new org.eclipse.swt.widgets.List((Composite)this, 2816);
        inputTypesList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        inputTypesList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AvailableConversionComposite.this.updateOutputTypesList((Class)AvailableConversionComposite.this.inputTypesClassList.get(inputTypesList.getSelectionIndex()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return inputTypesList;
    }

    private void populateInputTypesList() {
        this.inputTypesList.removeAll();
        TreeSet sortedSet = new TreeSet(new ShortTypesNameComparator());
        switch (this.classNameDisplayMode) {
            case SIMPLE_CLASS_NAME: {
                sortedSet = new TreeSet(new ShortTypesNameComparator());
                break;
            }
            case FULLY_QUALIFIED_CLASS_NAME: {
                sortedSet = new TreeSet(new FullyQualifiedTypesNameComparator());
                break;
            }
        }
        sortedSet.addAll(ApogyCommonConvertersGraphsFacade.INSTANCE.getAllInputTypes(this.convertersGraph));
        this.inputTypesClassList = new ArrayList();
        this.inputTypesClassList.addAll(sortedSet);
        for (Class<?> inputType : this.inputTypesClassList) {
            switch (this.classNameDisplayMode) {
                case SIMPLE_CLASS_NAME: {
                    this.inputTypesList.add(inputType.getSimpleName());
                    break;
                }
                case FULLY_QUALIFIED_CLASS_NAME: {
                    this.inputTypesList.add(inputType.getName());
                    break;
                }
            }
        }
        if (this.inputTypesClassList.size() > 0) {
            this.inputTypesList.setFocus();
            this.inputTypesList.setSelection(0);
            this.inputTypesList.select(0);
        }
    }

    private void updateOutputTypesList(Class<?> inputClass) {
        this.outputTypesList.removeAll();
        TreeSet sortedSet = new TreeSet(new ShortTypesNameComparator());
        sortedSet.addAll(this.conversionsMap.get(inputClass));
        ArrayList outputTypes = new ArrayList();
        outputTypes.addAll(sortedSet);
        for (Class outputType : outputTypes) {
            switch (this.classNameDisplayMode) {
                case SIMPLE_CLASS_NAME: {
                    this.outputTypesList.add(outputType.getSimpleName());
                    break;
                }
                case FULLY_QUALIFIED_CLASS_NAME: {
                    this.outputTypesList.add(outputType.getName());
                    break;
                }
            }
        }
    }
}

