/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.ui.composites;

import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSService;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class ROSServiceListCompositeOLD
extends Composite {
    private ROSInterface rosInterface;
    private ROSService<?, ?> selectedROSService = null;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;
    private Adapter serviceAdapter;

    public ROSServiceListCompositeOLD(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 400;
        gd_tree.minimumWidth = 400;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        TreeViewerColumn treeViewerColumnItem_State = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnState = treeViewerColumnItem_State.getColumn();
        trclmnState.setWidth(150);
        trclmnState.setText("State");
        TreeViewerColumn treeViewerColumnItem_Name = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnItem = treeViewerColumnItem_Name.getColumn();
        trclmnItem.setWidth(350);
        trclmnItem.setText("Service Name");
        TreeViewerColumn treeViewerColumnItem_AutoReconnect = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnAutoReconnect = treeViewerColumnItem_AutoReconnect.getColumn();
        trclmnAutoReconnect.setWidth(120);
        trclmnAutoReconnect.setText("Auto-Reconnect");
        TreeViewerColumn treeViewerColumnItem_Type = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnType = treeViewerColumnItem_Type.getColumn();
        trclmnType.setWidth(350);
        trclmnType.setText("Type");
        this.treeViewer.setContentProvider((IContentProvider)new CustomContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CustomLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ROSServiceListCompositeOLD.this.selectedROSService = (ROSService)((IStructuredSelection)event.getSelection()).getFirstElement();
                ROSServiceListCompositeOLD.this.newROSServiceSelected(ROSServiceListCompositeOLD.this.selectedROSService);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ROSServiceListCompositeOLD.this.m_bindingContext != null) {
                    ROSServiceListCompositeOLD.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public ROSInterface getROSInterface() {
        return this.rosInterface;
    }

    public void setROSInterface(ROSInterface rosInterface) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.rosInterface != null && this.rosInterface.getServiceManager() != null) {
            for (ROSService service : this.rosInterface.getServiceManager().getServices().values()) {
                service.eAdapters().remove((Object)this.getServiceAdapter());
            }
        }
        this.rosInterface = rosInterface;
        if (rosInterface != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput((Object)rosInterface);
            this.selectedROSService = this.getFirstROSService(rosInterface);
            if (this.selectedROSService != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.selectedROSService), true);
            }
            this.newROSServiceSelected(this.selectedROSService);
            if (this.rosInterface.getServiceManager() != null) {
                for (ROSService service : this.rosInterface.getServiceManager().getServices().values()) {
                    service.eAdapters().add((Object)this.getServiceAdapter());
                }
            }
        } else {
            this.treeViewer.setInput(null);
            this.treeViewer.setSelection(null, true);
            this.newROSServiceSelected(null);
        }
    }

    protected void newROSServiceSelected(ROSService<?, ?> rosService) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }

    protected ROSService<?, ?> getFirstROSService(ROSInterface rosInterface) {
        if (rosInterface.getServiceManager() != null && !rosInterface.getServiceManager().getServices().isEmpty()) {
            return (ROSService)rosInterface.getServiceManager().getServices().values().toArray()[0];
        }
        return null;
    }

    private Adapter getServiceAdapter() {
        if (this.serviceAdapter == null) {
            this.serviceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!ROSServiceListCompositeOLD.this.treeViewer.isBusy()) {
                        ROSServiceListCompositeOLD.this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ROSServiceListCompositeOLD.this.treeViewer.refresh(true);
                            }
                        });
                    }
                }
            };
        }
        return this.serviceAdapter;
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ROSInterface rosInterface;
            if (inputElement instanceof ROSInterface && (rosInterface = (ROSInterface)inputElement).getServiceManager() != null) {
                return rosInterface.getServiceManager().getServices().values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class CustomLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private static final int SERVICE_STATE_COLUMN_ID = 0;
        private static final int SERVICE_NAME_COLUMN_ID = 1;
        private static final int SERVICE_AUTO_RECONNECT_COLUMN_ID = 2;
        private static final int SERVICE_TYPE_COLUMN_ID = 3;

        public CustomLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 1: {
                    if (!(object instanceof ROSService)) break;
                    ROSService rosService = (ROSService)object;
                    str = rosService.getServiceName();
                    break;
                }
                case 2: {
                    str = "";
                    if (!(object instanceof ROSService)) break;
                    ROSService rosService = (ROSService)object;
                    if (rosService.isEnableAutoReconnect()) {
                        str = "Yes";
                        break;
                    }
                    str = "No";
                    break;
                }
                case 0: {
                    str = "";
                    if (!(object instanceof ROSService)) break;
                    ROSService rosService = (ROSService)object;
                    str = rosService.getServiceState().getLiteral();
                    break;
                }
                case 3: {
                    if (!(object instanceof ROSService)) break;
                    ROSService rosService = (ROSService)object;
                    str = rosService.getServiceType();
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }

        public Color getBackground(Object object, int columnIndex) {
            Color color = super.getBackground(object, columnIndex);
            if (object instanceof ROSService) {
                ROSService rosService = (ROSService)object;
                switch (rosService.getServiceState().getValue()) {
                    case 1: {
                        color = PlatformUI.getWorkbench().getDisplay().getSystemColor(7);
                        break;
                    }
                    case 2: {
                        color = PlatformUI.getWorkbench().getDisplay().getSystemColor(5);
                        break;
                    }
                    case 3: {
                        color = PlatformUI.getWorkbench().getDisplay().getSystemColor(15);
                        break;
                    }
                    case 4: {
                        color = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
                        break;
                    }
                }
            }
            return color;
        }
    }
}

