/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.ui.composites;

import org.eclipse.apogy.addons.ros.ROSInterface;
import org.eclipse.apogy.addons.ros.ROSService;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ROSServiceListComposite
extends EMFFormsEListComposite<ROSInterface, ROSInterface, ROSService<?, ?>> {
    public static final int SERVICE_STATE_MIN_WIDTH = 150;
    public static final int SERVICE_NAME_MIN_WIDTH = 250;
    public static final int SERVICE_AUTO_RECONNECT_MIN_WIDTH = 120;
    public static final int SERVICE_TYPE_MIN_WIDTH = 200;

    public ROSServiceListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, null, settings);
    }

    public ROSServiceListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn serviceStateColumn = new TreeViewerColumn(viewer, 0);
        serviceStateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        serviceStateColumn.getColumn().setText("State");
        serviceStateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSService rosService = (ROSService)element;
                return rosService.getServiceState().getLiteral();
            }

            public Color getBackground(Object element) {
                ROSService rosService = (ROSService)element;
                return ROSServiceListComposite.this.getBackground(rosService);
            }
        });
        TreeViewerColumn serviceNameColumn = new TreeViewerColumn(viewer, 0);
        serviceNameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
        serviceNameColumn.getColumn().setText("Service Name");
        serviceNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSService rosService = (ROSService)element;
                return rosService.getServiceName();
            }

            public Color getBackground(Object element) {
                ROSService rosService = (ROSService)element;
                return ROSServiceListComposite.this.getBackground(rosService);
            }
        });
        TreeViewerColumn serviceAutoReconnectColumn = new TreeViewerColumn(viewer, 0);
        serviceAutoReconnectColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        serviceAutoReconnectColumn.getColumn().setText("Auto-Reconnect");
        serviceAutoReconnectColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSService rosService = (ROSService)element;
                if (rosService.isEnableAutoReconnect()) {
                    return "Yes";
                }
                return "No";
            }

            public Color getBackground(Object element) {
                ROSService rosService = (ROSService)element;
                return ROSServiceListComposite.this.getBackground(rosService);
            }
        });
        TreeViewerColumn serviceTypeColumn = new TreeViewerColumn(viewer, 0);
        serviceTypeColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        serviceTypeColumn.getColumn().setText("Type");
        serviceTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ROSService rosService = (ROSService)element;
                return rosService.getServiceType();
            }

            public Color getBackground(Object element) {
                ROSService rosService = (ROSService)element;
                return ROSServiceListComposite.this.getBackground(rosService);
            }
        });
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return ROSServiceListComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object inputElement) {
                ROSInterface rosInterface;
                if (inputElement instanceof ROSInterface && (rosInterface = (ROSInterface)inputElement).getServiceManager() != null) {
                    return rosInterface.getServiceManager().getServices().values().toArray();
                }
                return new Object[0];
            }
        };
    }

    protected Color getBackground(ROSService<?, ?> rosService) {
        Color color = this.getBackground();
        switch (rosService.getServiceState().getValue()) {
            case 1: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(7);
                break;
            }
            case 2: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(5);
                break;
            }
            case 3: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(15);
                break;
            }
            case 4: {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
                break;
            }
        }
        return color;
    }
}

