/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.MenuIdDialog;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MenuContributionEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private final IListProperty ELEMENT_CONTAINER__CHILDREN = EMFProperties.list((EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    @Inject
    private IModelResource resource;
    @Inject
    private EModelService modelService;

    @Inject
    public MenuContributionEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.MenuEditor_AddHandledMenuItem, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.HandledMenuItem")){

            public void run() {
                MenuContributionEditor.this.handleAdd(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddMenu, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                MenuContributionEditor.this.handleAdd(MenuPackageImpl.Literals.MENU, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddDirectMenuItem, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.DirectMenuItem")){

            public void run() {
                MenuContributionEditor.this.handleAdd(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, false);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddSeparator, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.MenuSeparator")){

            public void run() {
                MenuContributionEditor.this.handleAdd(MenuPackageImpl.Literals.MENU_SEPARATOR, true);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_AddDynamicMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.DynamicMenuContribution")){

            public void run() {
                MenuContributionEditor.this.handleAdd(MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, false);
            }
        });
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.MenuContribution");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.MenuContributionEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.MenuContributionEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID));
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, (IObservableValue)this.getMaster(), context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__ACCESSIBILITY_PHRASE));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.MenuContributionEditor_ParentId);
        l.setToolTipText(this.Messages.MenuContributionEditor_ParentIdTooltip);
        l.setLayoutData((Object)new GridData(128));
        final Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)MenuPackageImpl.Literals.MENU_CONTRIBUTION__PARENT_ID).observeDetail((IObservableValue)this.getMaster()));
        Button b = new Button(parent, 0x800008);
        b.setText(this.Messages.ModelTooling_Common_FindEllipsis);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuIdDialog dialog = new MenuIdDialog(t.getShell(), MenuContributionEditor.this.resource, (MMenuContribution)MenuContributionEditor.this.getMaster().getValue(), MenuContributionEditor.this.getEditingDomain(), MenuContributionEditor.this.modelService, MenuContributionEditor.this.Messages);
                dialog.open();
            }
        });
        ControlFactory.createTextField(parent, this.Messages.MenuContributionEditor_Position, this.Messages.MenuContributionEditor_PositionTooltip, (IObservableValue)master, context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)MenuPackageImpl.Literals.MENU_CONTRIBUTION__POSITION_IN_PARENT));
        E4PickList pickList = new E4PickList(parent, 0, null, this.Messages, this, (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN){

            @Override
            protected void addPressed() {
                E4PickList.Struct struct = (E4PickList.Struct)((IStructuredSelection)this.getSelection()).getFirstElement();
                EClass eClass = struct.eClass;
                MMenuElement eObject = (MMenuElement)EcoreUtil.create((EClass)eClass);
                Command cmd = AddCommand.create((EditingDomain)MenuContributionEditor.this.getEditingDomain(), (Object)MenuContributionEditor.this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)eObject);
                if (cmd.canExecute()) {
                    MenuContributionEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                    if (!struct.separator) {
                        MenuContributionEditor.this.getEditor().setSelection(eObject);
                    }
                }
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.MenuContributionEditor_MenuItems);
        TableViewer viewer = pickList.getList();
        IEMFEditListProperty prop = EMFEditProperties.list((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
        viewer.setInput((Object)prop.observeDetail((IObservableValue)master));
        E4PickList.Struct defaultStruct = new E4PickList.Struct(this.Messages.MenuContributionEditor_HandledMenuItem, MenuPackageImpl.Literals.HANDLED_MENU_ITEM, false);
        pickList.setInput(new E4PickList.Struct[]{new E4PickList.Struct(this.Messages.MenuContributionEditor_Separator, MenuPackageImpl.Literals.MENU_SEPARATOR, true), new E4PickList.Struct(this.Messages.MenuContributionEditor_Menu, MenuPackageImpl.Literals.MENU, false), defaultStruct, new E4PickList.Struct(this.Messages.MenuContributionEditor_DirectMenuItem, MenuPackageImpl.Literals.DIRECT_MENU_ITEM, false), new E4PickList.Struct(this.Messages.MenuContributionEditor_DynamicMenuContribution, MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, false)});
        pickList.setSelection((ISelection)new StructuredSelection((Object)defaultStruct));
        ControlFactory.createCheckBox(parent, "To Be Rendered", (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED));
        ControlFactory.createCheckBox(parent, "Visible", (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MMenuContribution.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return this.ELEMENT_CONTAINER__CHILDREN.observe(element);
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    protected void handleAdd(EClass eClass, boolean separator) {
        MMenuElement eObject = (MMenuElement)EcoreUtil.create((EClass)eClass);
        this.setElementId(eObject);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)eObject);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            if (!separator) {
                this.getEditor().setSelection(eObject);
            }
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }
}

