/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common.component;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public class IdGenerator {
    private IValueChangeListener listener;
    private IObservableValue observableValue;
    protected boolean ignore;
    private IValueChangeListener listener2;
    private IObservableValue observableValue2;
    static Pattern patternId = Pattern.compile("^(.*\\.)\\d+$");

    public void bind(IObservableValue master, IEMFEditValueProperty ebpLabel, IEMFEditValueProperty evpId, Control control) {
        Matcher m;
        String origLabel = (String)ebpLabel.getValue(master.getValue());
        if (E.notEmpty(origLabel)) {
            this.stopGenerating();
            return;
        }
        String origId = (String)evpId.getValue(master.getValue());
        if (origId == null) {
            origId = "id.0";
        }
        if (!(m = patternId.matcher(origId)).matches()) {
            this.stopGenerating();
            return;
        }
        String baseId = m.group(1);
        if (control != null) {
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    IdGenerator.this.stopGenerating();
                }
            });
            control.addDisposeListener(e -> this.stopGenerating());
        }
        this.observableValue2 = evpId.observe(master.getValue());
        this.listener2 = event -> {
            if (!this.ignore) {
                this.stopGenerating();
            }
        };
        this.observableValue2.addValueChangeListener(this.listener2);
        this.observableValue = ebpLabel.observe(master.getValue());
        this.listener = event -> {
            String labelValue = (String)ebpLabel.getValue(master.getValue());
            if (labelValue == null) {
                labelValue = "";
            }
            String trimmedIdEnding = IdGenerator.trimToLowercase(labelValue);
            this.ignore = true;
            evpId.setValue(master.getValue(), (Object)(String.valueOf(baseId) + trimmedIdEnding));
            this.ignore = false;
        };
        this.observableValue.addValueChangeListener(this.listener);
    }

    protected static String trimToLowercase(String value) {
        String[] parts = value.split("\\s+");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            part = part.replaceAll("[^0-9a-zA-Z_-]", "");
            sb.append(part.toLowerCase());
            ++n2;
        }
        return sb.toString();
    }

    public void stopGenerating() {
        if (this.observableValue != null) {
            this.observableValue.removeValueChangeListener(this.listener);
            this.listener = null;
            this.observableValue = null;
        }
        if (this.observableValue2 != null) {
            this.observableValue2.removeValueChangeListener(this.listener2);
            this.listener2 = null;
            this.observableValue2 = null;
        }
    }
}

