/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer.preferences;

import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TopologyViewerPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor viewerVerboseEditor;
    private BooleanFieldEditor viewerAntiAliasingEditor;
    private IntegerFieldEditor viewerMaximumFrameRateEditor;
    private StringFieldEditor navigationLinearLowSpeedFactorEditor;
    private StringFieldEditor navigationLinearHighSpeedFactorEditor;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpViewerSettings = new Group(container, 0);
        grpViewerSettings.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpViewerSettings.setLayout((Layout)new GridLayout(1, true));
        grpViewerSettings.setText("Viewer Settings");
        this.viewerVerboseEditor = this.createBooleanFieldEditor((Composite)grpViewerSettings, "VIEWER_VERBOSE_ID", "Verbose Enabled");
        this.viewerAntiAliasingEditor = this.createBooleanFieldEditor((Composite)grpViewerSettings, "VIEWER_ANTI_ALIASING_ID", "Anti-Aliasing Enabled");
        this.viewerMaximumFrameRateEditor = this.createIntegerFieldEditor((Composite)grpViewerSettings, "VIEWER_MAX_FRAME_RATE_ID", "Maximum Frame Rate");
        Group grpNavigationSpeeds = new Group(container, 0);
        grpNavigationSpeeds.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpNavigationSpeeds.setLayout((Layout)new GridLayout(1, true));
        grpNavigationSpeeds.setText("Navigation Settings");
        this.navigationLinearLowSpeedFactorEditor = this.createStringFieldEditor((Composite)grpNavigationSpeeds, "DEFAULT_LINEAR_LOW_SPEED_FACTOR_ID", "Linear Low Speed Factor");
        this.navigationLinearHighSpeedFactorEditor = this.createStringFieldEditor((Composite)grpNavigationSpeeds, "DEFAULT_LINEAR_HIGH_SPEED_FACTOR_ID", "Linear High Speed Factor");
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        this.viewerVerboseEditor.loadDefault();
        this.viewerAntiAliasingEditor.loadDefault();
        this.viewerMaximumFrameRateEditor.loadDefault();
        this.navigationLinearLowSpeedFactorEditor.loadDefault();
        this.navigationLinearHighSpeedFactorEditor.loadDefault();
        super.performDefaults();
    }

    private StringFieldEditor createStringFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        editorContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        StringFieldEditor editor = new StringFieldEditor(preferenceID, preferenceLabel, editorContainer);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        editorContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        IntegerFieldEditor editor = new IntegerFieldEditor(preferenceID, preferenceLabel, editorContainer);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private BooleanFieldEditor createBooleanFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        editorContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        BooleanFieldEditor editor = new BooleanFieldEditor(preferenceID, preferenceLabel, editorContainer);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }

    private void storePreferences() {
        this.viewerVerboseEditor.store();
        this.viewerAntiAliasingEditor.store();
        this.viewerMaximumFrameRateEditor.store();
        this.navigationLinearLowSpeedFactorEditor.store();
        this.navigationLinearHighSpeedFactorEditor.store();
    }
}

