/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer.preferences;

import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.preferences.TopologyViewerLightingPreferenceConstants;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class TopologyViewerLightingPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AMBIENT_LIGHT_COLOR_ID", (RGB)TopologyViewerLightingPreferenceConstants.AMBIENT_LIGHT_COLOR_DEFAULT);
        String vectorString = TopologyViewerLightingPreferenceInitializer.getTuple3dPreferenceStoreString(TopologyViewerLightingPreferenceConstants.AMBIENT_LIGHT_DIRECTION_DEFAULT);
        store.setDefault("AMBIENT_LIGHT_DIRECTION_ID", vectorString);
    }

    public static String getTuple3dPreferenceStoreString(Tuple3d tuple3d) {
        String vectorString = String.valueOf(tuple3d.getX()) + ", " + tuple3d.getY() + ", " + tuple3d.getZ();
        return vectorString;
    }

    public static Tuple3d getTuple3dFromPreferenceStoreString(String vectorString) {
        String[] items;
        Tuple3d direction = null;
        if (vectorString != null && (items = vectorString.split(",")).length >= 3) {
            double x = Double.parseDouble(items[0].trim());
            double y = Double.parseDouble(items[1].trim());
            double z = Double.parseDouble(items[2].trim());
            direction = ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z);
        }
        return direction;
    }

    public static Tuple3d getTuple3dFromPreferenceStore(IPreferenceStore store) {
        String string = store.getString("AMBIENT_LIGHT_DIRECTION_ID");
        return TopologyViewerLightingPreferenceInitializer.getTuple3dFromPreferenceStoreString(string);
    }
}

