/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.optimization.AbstractConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.util.FastMath;

@Deprecated
public class SimpleVectorValueChecker
extends AbstractConvergenceChecker<PointVectorValuePair> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    @Deprecated
    public SimpleVectorValueChecker() {
        this.maxIterationCount = -1;
    }

    public SimpleVectorValueChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
        this.maxIterationCount = -1;
    }

    public SimpleVectorValueChecker(double relativeThreshold, double absoluteThreshold, int maxIter) {
        super(relativeThreshold, absoluteThreshold);
        if (maxIter <= 0) {
            throw new NotStrictlyPositiveException(maxIter);
        }
        this.maxIterationCount = maxIter;
    }

    @Override
    public boolean converged(int iteration, PointVectorValuePair previous, PointVectorValuePair current) {
        if (this.maxIterationCount != -1 && iteration >= this.maxIterationCount) {
            return true;
        }
        double[] p = previous.getValueRef();
        double[] c = current.getValueRef();
        int i = 0;
        while (i < p.length) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = FastMath.abs(pi - ci);
            if (difference > (size = FastMath.max(FastMath.abs(pi), FastMath.abs(ci))) * this.getRelativeThreshold() && difference > this.getAbsoluteThreshold()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

