/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.ui.wizards.AbstractAssemblyLinkWizardPage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class AssemblyLinkDestinationWizardPage
extends AbstractAssemblyLinkWizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.AssemblyLinkDestinationWizardPage";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Tree subSystemTree;
    private TreeViewer subSystemTreeViewer;
    private TypeMember selectedSubSystem = null;

    public AssemblyLinkDestinationWizardPage(ApogySystem apogySystem, AssemblyLink assemblyLink) {
        super(WIZARD_PAGE_ID, apogySystem, assemblyLink);
        this.setTitle("Assembly link sub system");
        this.setDescription("Set the sub-system the assembly link refers to.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)container);
        Group parentSystemGroup = new Group(container, 2048);
        parentSystemGroup.setLayout((Layout)new FillLayout());
        parentSystemGroup.setText("Sub-System");
        parentSystemGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createParentSystemComposite((Composite)parentSystemGroup);
    }

    private Composite createParentSystemComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.subSystemTreeViewer = new TreeViewer(container, 68354);
        this.subSystemTree = this.subSystemTreeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 2, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.subSystemTree.setLayoutData((Object)gd_tree);
        this.subSystemTree.setLinesVisible(true);
        this.subSystemTreeViewer.setContentProvider((IContentProvider)new ApogySystemContentProvider());
        this.subSystemTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.subSystemTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssemblyLinkDestinationWizardPage.this.selectedSubSystem = (TypeMember)((IStructuredSelection)event.getSelection()).getFirstElement();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkDestinationWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__SUB_SYSTEM_TYPE_MEMBER, (Object)AssemblyLinkDestinationWizardPage.this.selectedSubSystem, true);
                AssemblyLinkDestinationWizardPage.this.validate();
            }
        });
        this.subSystemTreeViewer.setInput(this.getAllTypeMembers(this.apogySystem));
        Button btnClearParentSystem = new Button(container, 0);
        btnClearParentSystem.setSize(74, 29);
        btnClearParentSystem.setText("Clear");
        btnClearParentSystem.setToolTipText("Clear the parent system for the Assembly Link. This is interprated as being the system itself.");
        btnClearParentSystem.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnClearParentSystem.setEnabled(true);
        btnClearParentSystem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AssemblyLinkDestinationWizardPage.this.subSystemTreeViewer.setSelection((ISelection)new StructuredSelection(), true);
                AssemblyLinkDestinationWizardPage.this.validate();
            }
        });
        return container;
    }

    @Override
    protected List<TypeMember> getAllTypeMembers(ApogySystem apogySystem) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        for (TypeMember member : apogySystem.getMembers()) {
            list.addAll(this.recursiveGetAllTypeMembers(member));
        }
        return list;
    }

    @Override
    protected List<TypeMember> recursiveGetAllTypeMembers(TypeMember typeMember) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        list.add(typeMember);
        Type type = this.load(typeMember.getMemberType());
        if (type != null) {
            for (TypeMember member : type.getMembers()) {
                list.addAll(this.recursiveGetAllTypeMembers(member));
            }
        }
        return list;
    }

    protected void validate() {
        String errorMessage = null;
        if (this.assemblyLink.getSubSystemTypeMember() == null) {
            errorMessage = "No Sub-System specified !";
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private class ApogySystemContentProvider
    implements ITreeContentProvider {
        List<AssemblyLink> allAssemblylinks;

        public ApogySystemContentProvider() {
            this.allAssemblylinks = AssemblyLinkDestinationWizardPage.this.getAllAssemblyLinks(AssemblyLinkDestinationWizardPage.this.apogySystem);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                return this.filter(collection).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                Collection collection = (Collection)parentElement;
                return this.filter(collection).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Collection) {
                Collection collection = (Collection)element;
                return this.filter(collection).isEmpty();
            }
            return false;
        }

        private Collection<TypeMember> filter(Collection<?> members) {
            ArrayList<TypeMember> result = new ArrayList<TypeMember>();
            for (Object obj : members) {
                TypeMember typeMember;
                if (!(obj instanceof TypeMember) || this.isMapped(typeMember = (TypeMember)obj, this.allAssemblylinks)) continue;
                result.add(typeMember);
            }
            return result;
        }

        private boolean isMapped(TypeMember typeMember, List<AssemblyLink> allAssemblylinks) {
            boolean isMapped = false;
            for (AssemblyLink assemblyLink : allAssemblylinks) {
                TypeMember target = assemblyLink.getSubSystemTypeMember();
                if (target != typeMember) continue;
                isMapped = true;
            }
            return isMapped;
        }
    }
}

