/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.util.List;
import org.eclipse.apogy.core.WorksiteContributor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class WorksiteContributorsListComposite
extends Composite {
    protected List<WorksiteContributor> contributors = null;
    protected TableViewer tableViewer = null;
    protected WorksiteContributor selectedWorksiteContributor = null;

    public WorksiteContributorsListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.tableViewer = this.createTableViewer(this);
    }

    public WorksiteContributorsListComposite(Composite parent, int style, List<WorksiteContributor> contributors) {
        this(parent, style);
        this.setContributors(contributors);
    }

    public List<WorksiteContributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<WorksiteContributor> contributors) {
        this.contributors = contributors;
        this.tableViewer.setInput(contributors);
    }

    public WorksiteContributor getSelectedWorksiteContributor() {
        return this.selectedWorksiteContributor;
    }

    public void setSelectedWorksiteContributor(WorksiteContributor selectedWorksiteContributor) {
        this.selectedWorksiteContributor = selectedWorksiteContributor;
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)selectedWorksiteContributor));
    }

    protected TableViewer createTableViewer(Composite parent) {
        final TableViewer viewer = new TableViewer(parent, 68354);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 0);
        nameColumn.getColumn().setWidth(250);
        nameColumn.getColumn().setText("Name");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WorksiteContributor contributor = (WorksiteContributor)element;
                return contributor.name;
            }
        });
        TableViewerColumn descriptionColumn = new TableViewerColumn(viewer, 0);
        descriptionColumn.getColumn().setWidth(200);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                WorksiteContributor contributor = (WorksiteContributor)element;
                return contributor.description;
            }
        });
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof WorksiteContributor) {
                    WorksiteContributorsListComposite.this.selectedWorksiteContributor = (WorksiteContributor)firstElement;
                    WorksiteContributorsListComposite.this.newWorksiteContributorSelected(WorksiteContributorsListComposite.this.selectedWorksiteContributor);
                }
            }
        });
        return viewer;
    }

    protected void newWorksiteContributorSelected(WorksiteContributor selectedWorksiteContributor) {
    }
}

