/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Described;
import org.eclipse.apogy.common.emf.edit.utils.ApogyCommonEMFEditUtilsFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.OperationCallPositionedResult;
import org.eclipse.apogy.core.Positioned;
import org.eclipse.apogy.core.PositionedResult;
import org.eclipse.apogy.core.invocator.AbstractResultValue;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.AttributeResultValue;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.ReferenceResultValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionedResultListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(PositionedResultListComposite.class);
    private static final int NAME_COLUMN_ID = 0;
    private static final int DESCRIPTION_COLUMN_ID = 1;
    private static final int TIME_COLUMN_ID = 2;
    private static final int POSITION_COLUMN_ID = 3;
    private static final int ORIENTATION_COLUMN_ID = 4;
    private static final int VALUE_COLUMN_ID = 5;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final List<PositionedResult> positionedResultList = new ArrayList<PositionedResult>();
    protected PositionedResult selectedPositionedResult = null;
    protected List<PositionedResult> selectedPositionedResults = new ArrayList<PositionedResult>();
    private final TableViewer tableViewer;
    private final Table table;
    private final Button btnNew;
    private final Button btnDelete;

    public PositionedResultListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer((Composite)this, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tblclmnNodeId = new TableColumn(this.table, 0);
        tblclmnNodeId.setWidth(100);
        tblclmnNodeId.setText("Name");
        TableColumn tblclmnNodeDescription = new TableColumn(this.table, 0);
        tblclmnNodeDescription.setWidth(300);
        tblclmnNodeDescription.setText("Description");
        TableColumn tblclmnDate = new TableColumn(this.table, 0);
        tblclmnDate.setWidth(220);
        tblclmnDate.setText("Date");
        TableColumn tblclmnPosition = new TableColumn(this.table, 0);
        tblclmnPosition.setWidth(130);
        tblclmnPosition.setText("Position (m)");
        TableColumn tblclmnOrientation = new TableColumn(this.table, 0);
        tblclmnOrientation.setWidth(130);
        tblclmnOrientation.setText("Orientation (deg)");
        TableColumn tblclmnValue = new TableColumn(this.table, 0);
        tblclmnValue.setWidth(300);
        tblclmnValue.setText("Value");
        this.tableViewer.setContentProvider((IContentProvider)new NodeContentProvider((AdapterFactory)this.adapterFactory));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PositionedResultLabelProvider((AdapterFactory)this.adapterFactory));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    PositionedResultListComposite.this.selectedPositionedResults.clear();
                    if (!iStructuredSelection.isEmpty()) {
                        PositionedResultListComposite.this.positionedResultSelectedChanged((PositionedResult)iStructuredSelection.getFirstElement());
                        ArrayList<PositionedResult> nodesSelected = new ArrayList<PositionedResult>();
                        List selectedObjects = iStructuredSelection.toList();
                        for (Object object : selectedObjects) {
                            if (!(object instanceof PositionedResult)) continue;
                            nodesSelected.add((PositionedResult)object);
                        }
                        PositionedResultListComposite.this.selectedPositionedResults.addAll(nodesSelected);
                        PositionedResultListComposite.this.btnDelete.setEnabled(true);
                        PositionedResultListComposite.this.positionedResultsSelectedChanged(nodesSelected);
                    } else {
                        PositionedResultListComposite.this.btnDelete.setEnabled(false);
                        PositionedResultListComposite.this.positionedResultSelectedChanged(null);
                        PositionedResultListComposite.this.positionedResultsSelectedChanged(new ArrayList<PositionedResult>());
                    }
                }
            }
        });
        Composite buttonsComposite = new Composite((Composite)this, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(buttonsComposite, 0);
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnNew.setText("New");
        this.btnNew.setEnabled(false);
        this.btnDelete = new Button(buttonsComposite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String deleteMessage = "";
                Iterator<PositionedResult> results = PositionedResultListComposite.this.selectedPositionedResults.iterator();
                int i = 0;
                while (results.hasNext()) {
                    PositionedResult result = results.next();
                    if (i < 20) {
                        deleteMessage = String.valueOf(deleteMessage) + result.getName();
                        if (results.hasNext()) {
                            deleteMessage = String.valueOf(deleteMessage) + ", ";
                        }
                    } else if (!results.hasNext()) {
                        deleteMessage = String.valueOf(deleteMessage) + "...," + result.getName();
                    }
                    ++i;
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Results", null, "Are you sure to delete these Results ? : " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    ArrayList<PositionedResult> toDelete = new ArrayList<PositionedResult>();
                    toDelete.addAll(PositionedResultListComposite.this.selectedPositionedResults);
                    for (PositionedResult positionedResult : toDelete) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)positionedResult.getResultsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.RESULTS_LIST__RESULTS, (Object)positionedResult, true);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the PositionnedResult <" + positionedResult.getName() + ">.", (Throwable)e);
                        }
                    }
                }
                if (!PositionedResultListComposite.this.tableViewer.isBusy()) {
                    PositionedResultListComposite.this.tableViewer.setInput((Object)PositionedResultListComposite.this.positionedResultList);
                }
            }
        });
    }

    public Collection<PositionedResult> getPositionedResultList() {
        return this.positionedResultList;
    }

    public void setPositionedResultList(Collection<PositionedResult> positionedResultList) {
        this.positionedResultList.clear();
        if (positionedResultList != null) {
            this.positionedResultList.addAll(positionedResultList);
            this.tableViewer.setInput(this.positionedResultList);
        }
    }

    protected void positionedResultSelectedChanged(PositionedResult positionedResult) {
    }

    protected void positionedResultsSelectedChanged(Collection<PositionedResult> positionedResults) {
    }

    private class NodeContentProvider
    extends AdapterFactoryContentProvider {
        public NodeContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof Collection) {
                return ((Collection)object).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }

    private class PositionedResultLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final DecimalFormat positionFormat;
        private final DecimalFormat orientationFormat;

        public PositionedResultLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.positionFormat = new DecimalFormat("0.00");
            this.orientationFormat = new DecimalFormat("0.0");
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 0: {
                    if (object instanceof ENamedElement) {
                        str = ((ENamedElement)object).getName();
                        break;
                    }
                    if (!(object instanceof OperationCallResult)) break;
                    OperationCallResult result = (OperationCallResult)object;
                    str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)result.getOperationCall());
                    break;
                }
                case 1: {
                    if (!(object instanceof Described)) break;
                    str = ((Described)object).getDescription();
                    break;
                }
                case 2: {
                    Date date;
                    if (!(object instanceof PositionedResult) || (date = ((PositionedResult)object).getTime()) == null) break;
                    str = ApogyCommonEMFFacade.INSTANCE.format(date);
                    break;
                }
                case 3: {
                    str = "N/A.";
                    if (!(object instanceof Positioned)) break;
                    Positioned positioned = (Positioned)object;
                    Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(positioned.getPose());
                    str = String.valueOf(this.positionFormat.format(position.getX())) + ", " + this.positionFormat.format(position.getY()) + ", " + this.positionFormat.format(position.getZ());
                    break;
                }
                case 4: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    if (object instanceof OperationCallPositionedResult) {
                        OperationCallPositionedResult result = (OperationCallPositionedResult)object;
                        if (result.getPose() == null) {
                            str = "Null";
                            break;
                        }
                        Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(result.getPose());
                        orientation.setX(Math.toDegrees(orientation.getX()));
                        orientation.setY(Math.toDegrees(orientation.getY()));
                        orientation.setZ(Math.toDegrees(orientation.getZ()));
                        str = String.valueOf(this.orientationFormat.format(orientation.getX())) + ", " + this.orientationFormat.format(orientation.getY()) + ", " + this.orientationFormat.format(orientation.getZ());
                        break;
                    }
                    str = "N/A.";
                    break;
                }
                case 5: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    OperationCallResult result = (OperationCallResult)object;
                    if (result.getExceptionContainer() != null && result.getExceptionContainer().getException() != null) {
                        str = result.getExceptionContainer().getException().getMessage();
                        break;
                    }
                    AbstractResultValue abstractResultValue = result.getResultValue();
                    if (abstractResultValue instanceof AttributeResultValue) {
                        AttributeResultValue attributeResultValue = (AttributeResultValue)abstractResultValue;
                        if (attributeResultValue.getValue().getObject() != null) {
                            str = attributeResultValue.getValue().getObject().toString();
                            break;
                        }
                        str = "<null>";
                        break;
                    }
                    if (!(abstractResultValue instanceof ReferenceResultValue)) break;
                    ReferenceResultValue referenceResultValue = (ReferenceResultValue)abstractResultValue;
                    str = result.getResultValue() == null ? "<null>" : ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)referenceResultValue.getValue());
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }

        public Color getBackground(Object object, int columnIndex) {
            OperationCallResult opResult;
            Color color = super.getBackground(object, columnIndex);
            if (object instanceof OperationCallResult && (opResult = (OperationCallResult)object).getExceptionContainer() != null && opResult.getExceptionContainer().getException() != null) {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
            }
            return color;
        }
    }
}

