/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.FeatureOfInterestNode;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FeatureOfInterestListComposite
extends EMFFormsEListComposite<FeaturesOfInterestMapLayer, FeatureOfInterestList, FeatureOfInterest> {
    public FeatureOfInterestListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.FEATURES_OF_INTEREST_MAP_LAYER__FEATURES}), (EStructuralFeature)ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSelectButton(parent, style);
        this.createUnSelectButton(parent, style);
        this.createShowButton(parent, style).setToolTipText("Has the selected Feature Of Interest visible in the 3D viewer.");
        this.createHideButton(parent, style).setToolTipText("Has the selected Feature Of Interest invisible in the 3D viewer.");
        this.createShowAllButton(parent, style);
        this.createHideAllButton(parent, style);
    }

    protected void doNew() {
        EObjectWizard wizard = new EObjectWizard((EObject)((FeaturesOfInterestMapLayer)this.getRootEObject()), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.FEATURES_OF_INTEREST_MAP_LAYER__FEATURES}), ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST__FEATURES_OF_INTEREST, ApogyCorePackage.Literals.FEATURE_OF_INTEREST, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected Button createSelectButton(Composite parent, int style) {
        Button btn = FeatureOfInterestListComposite.createButton((Composite)parent, (int)0, (String)"Select", (Listener)new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)FeatureOfInterestListComposite.this.getDisplay(), () -> FeatureOfInterestListComposite.this.doSelect());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                FeatureOfInterestListComposite.this.refreshViewer();
            }
        });
        btn.setToolTipText("Has the selected Feature Of Interest start flashing in the 3D viewer.");
        this.createSelectButtonBindings(btn);
        return btn;
    }

    protected void createSelectButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected Button createUnSelectButton(Composite parent, int style) {
        Button btn = FeatureOfInterestListComposite.createButton((Composite)parent, (int)0, (String)"Un-Select", (Listener)new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)FeatureOfInterestListComposite.this.getDisplay(), () -> FeatureOfInterestListComposite.this.doUnSelect());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                FeatureOfInterestListComposite.this.refreshViewer();
            }
        });
        btn.setToolTipText("Has the selected Feature Of Interest stop flashing in the 3D viewer.");
        this.createUnSelectButtonBindings(btn);
        return btn;
    }

    protected void createUnSelectButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected Button createShowAllButton(Composite parent, int style) {
        Button btn = FeatureOfInterestListComposite.createButton((Composite)parent, (int)0, (String)"Show All", (Listener)new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)FeatureOfInterestListComposite.this.getDisplay(), () -> FeatureOfInterestListComposite.this.doShowAll());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                FeatureOfInterestListComposite.this.refreshViewer();
            }
        });
        btn.setToolTipText("Has all Feature Of Interest made visible in the 3D viewer.");
        this.createShowAllButtonBindings(btn);
        return btn;
    }

    protected void createShowAllButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.getResolvedEObject() != null && !((FeatureOfInterestList)this.getResolvedEObject()).getFeaturesOfInterest().isEmpty()) {
                return true;
            }
            return false;
        });
    }

    protected Button createHideAllButton(Composite parent, int style) {
        Button btn = FeatureOfInterestListComposite.createButton((Composite)parent, (int)0, (String)"Hide All", (Listener)new Listener(){

            public void handleEvent(Event event) {
                try {
                    BusyIndicator.showWhile((Display)FeatureOfInterestListComposite.this.getDisplay(), () -> FeatureOfInterestListComposite.this.doHideAll());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                FeatureOfInterestListComposite.this.refreshViewer();
            }
        });
        btn.setToolTipText("Has all Feature Of Interest made invisible in the 3D viewer.");
        this.createHideAllButtonBindings(btn);
        return btn;
    }

    protected void createHideAllButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.getResolvedEObject() != null && !((FeatureOfInterestList)this.getResolvedEObject()).getFeaturesOfInterest().isEmpty()) {
                return true;
            }
            return false;
        });
    }

    protected void doShow() {
        for (FeatureOfInterest foi : this.getSelectedItemObjects()) {
            this.setNodeVisibility(foi, true);
        }
    }

    protected void doShowAll() {
        if (this.getResolvedEObject() != null) {
            for (FeatureOfInterest foi : ((FeatureOfInterestList)this.getResolvedEObject()).getFeaturesOfInterest()) {
                this.setNodeVisibility(foi, true);
            }
        }
    }

    protected void doHideAll() {
        if (this.getResolvedEObject() != null) {
            for (FeatureOfInterest foi : ((FeatureOfInterestList)this.getResolvedEObject()).getFeaturesOfInterest()) {
                this.setNodeVisibility(foi, false);
            }
        }
    }

    protected void doHide() {
        for (FeatureOfInterest foi : this.getSelectedItemObjects()) {
            this.setNodeVisibility(foi, false);
        }
    }

    protected void doSelect() {
        for (FeatureOfInterest foi : this.getSelectedItemObjects()) {
            this.select(foi, true);
        }
    }

    protected void doUnSelect() {
        for (FeatureOfInterest foi : this.getSelectedItemObjects()) {
            this.select(foi, false);
        }
    }

    protected void setNodeVisibility(FeatureOfInterest foi, boolean visible) {
        ApogyTopology apogyTopology = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology();
        if (apogyTopology != null) {
            GroupNode root = apogyTopology.getRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCorePackage.Literals.FEATURE_OF_INTEREST_NODE, (Node)root);
            for (Node node : nodes) {
                NodePresentation nodePresentation;
                FeatureOfInterestNode featureOfInterestNode = (FeatureOfInterestNode)node;
                if (featureOfInterestNode.getFeatureOfInterest() != foi || (nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)featureOfInterestNode)) == null) continue;
                nodePresentation.setVisible(visible);
            }
        }
    }

    protected void select(FeatureOfInterest foi, boolean selected) {
        ApogyTopology apogyTopology = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology();
        if (apogyTopology != null) {
            GroupNode root = apogyTopology.getRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyCorePackage.Literals.FEATURE_OF_INTEREST_NODE, (Node)root);
            for (Node node : nodes) {
                NodePresentation nodePresentation;
                FeatureOfInterestNode featureOfInterestNode = (FeatureOfInterestNode)node;
                if (featureOfInterestNode.getFeatureOfInterest() != foi || (nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)featureOfInterestNode)) == null) continue;
                nodePresentation.setSelected(selected);
            }
        }
    }
}

