/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.DirectionalLightShadowFilter;
import com.jme3.shadow.DirectionalLightShadowRenderer;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.texture.Texture;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.moon.surface.MoonSky;
import org.eclipse.apogy.core.environment.moon.surface.MoonSkyNode;
import org.eclipse.apogy.core.environment.moon.surface.ui.jme3.Activator;
import org.eclipse.apogy.core.environment.moon.surface.ui.scene_objects.MoonSkySceneObject;
import org.eclipse.apogy.core.environment.ui.StarFieldPresentation;
import org.eclipse.apogy.core.environment.ui.scene_objects.StarFieldSceneObject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoonSkyNodeJME3Object
extends DefaultJME3SceneObject<MoonSkyNode>
implements IPropertyChangeListener,
MoonSkySceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(MoonSkyNodeJME3Object.class);
    private Adapter sunAdapter;
    private Adapter earthAdapter;
    private MoonSky moonSky;
    private AssetManager assetManager;
    private static ColorRGBA SUN_SPHERE_COLOR = new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f);
    private static ColorRGBA EARTH_SPHERE_COLOR = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private com.jme3.scene.Node sunTransform = null;
    private Geometry sunSphere;
    private DirectionalLight sunLight;
    private boolean sunVisible = false;
    private boolean sunShadowsEnabled = false;
    private boolean sunCastingShadows = false;
    private com.jme3.scene.Node earthTransform = null;
    private Geometry earthSphere;
    private DirectionalLight earthLight;
    private boolean earthLightingEnabled = Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_MOON_SURFACE_EARTH_LIGHTING_ENABLED_ID");
    private boolean earthVisible = false;
    private boolean earthShadowsEnabled = false;
    private boolean earthCastingShadows = false;
    private boolean enableBloom = true;
    private FilterPostProcessor bloomFilterPostProcessor;
    private BloomFilter bloomFilter;
    private int shadowMapSize = 2048;
    private FilterPostProcessor shadowsFilterPostProcessor;
    private DirectionalLightShadowRenderer directionalLightShadowRenderer;
    private DirectionalLightShadowFilter directionalLightShadowFilter;

    public MoonSkyNodeJME3Object(MoonSkyNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager = this.jme3Application.getAssetManager();
        this.assetManager.registerLocator("/", com.jme3.asset.plugins.FileLocator.class);
        this.moonSky = (MoonSky)node.getSky();
        Job job = new Job("EarthSkyNodeJME3Object initialize."){

            protected IStatus run(IProgressMonitor monitor) {
                MoonSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        String urlString = "platform:plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(MoonSkyNodeJME3Object.class) + "/assets";
                        URL url = FileLocator.toFileURL((URL)new URL(urlString));
                        MoonSkyNodeJME3Object.this.assetManager.registerLocator(url.getPath(), com.jme3.asset.plugins.FileLocator.class);
                        MoonSkyNodeJME3Object.this.attachSun();
                        MoonSkyNodeJME3Object.this.attachEarth();
                        MoonSkyNodeJME3Object.this.requestUpdate();
                        MoonSkyNodeJME3Object.this.enableBloom(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_BLOOM_ENABLED_ID"));
                        MoonSkyNodeJME3Object.this.setShadowMapSize(Activator.getDefault().getPreferenceStore().getInt("DEFAULT_SHADOW_MAP_SIZE_ID"));
                        MoonSkyNodeJME3Object.this.setSunShadowsEnabled(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID"));
                        MoonSkyNodeJME3Object.this.setEarthShadowsEnabled(Activator.getDefault().getPreferenceStore().getBoolean("DEFAULT_EARTH_CAST_SHADOWS_ENABLED_ID"));
                        MoonSkyNodeJME3Object.this.updateSunEarthVisibilityAndShadows();
                        StarFieldSceneObject starFieldSceneObject = MoonSkyNodeJME3Object.this.resolveStarFieldSceneObject();
                        if (starFieldSceneObject != null) {
                            starFieldSceneObject.setTransparency(0.0f);
                        }
                        MoonSkyNodeJME3Object.this.moonSky.getSun().getParent().eAdapters().add((Object)MoonSkyNodeJME3Object.this.getSunAdapter());
                        MoonSkyNodeJME3Object.this.moonSky.getEarth().getParent().eAdapters().add((Object)MoonSkyNodeJME3Object.this.getEarthAdapter());
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void updateGeometry(float tpf) {
        this.updateSunEarthVisibilityAndShadows();
        this.updateSun();
        this.updateEarth();
    }

    public void dispose() {
        this.setLightSourceCreatingShadow(null);
        if (this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
            this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
        }
        if (this.sunLight != null) {
            this.jme3Application.getRootNode().removeLight((Light)this.sunLight);
        }
        if (this.earthLight != null) {
            this.jme3Application.getRootNode().removeLight((Light)this.earthLight);
        }
        super.dispose();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (event.getProperty().compareTo("DEFAULT_BLOOM_ENABLED_ID") == 0) {
                    boolean value = store.getBoolean("DEFAULT_BLOOM_ENABLED_ID");
                    MoonSkyNodeJME3Object.this.enableBloom(value);
                    MoonSkyNodeJME3Object.this.updateSun();
                } else if (event.getProperty().compareTo("DEFAULT_SHADOW_MAP_SIZE_ID") == 0) {
                    MoonSkyNodeJME3Object.this.setShadowMapSize(store.getInt("DEFAULT_SHADOW_MAP_SIZE_ID"));
                } else if (event.getProperty().compareTo("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID") == 0) {
                    boolean value = store.getBoolean("DEFAULT_SUN_CAST_SHADOWS_ENABLED_ID");
                    MoonSkyNodeJME3Object.this.setSunShadowsEnabled(value);
                } else if (event.getProperty().compareTo("DEFAULT_EARTH_CAST_SHADOWS_ENABLED_ID") == 0) {
                    boolean value = store.getBoolean("DEFAULT_EARTH_CAST_SHADOWS_ENABLED_ID");
                    MoonSkyNodeJME3Object.this.setEarthShadowsEnabled(value);
                } else if (event.getProperty().compareTo("DEFAULT_MOON_SURFACE_EARTH_LIGHTING_ENABLED_ID") == 0) {
                    boolean value = store.getBoolean("DEFAULT_MOON_SURFACE_EARTH_LIGHTING_ENABLED_ID");
                    MoonSkyNodeJME3Object.this.setEarthLightingEnabled(value);
                }
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.sunSphere != null) {
            geometries.add(this.sunSphere);
        }
        if (this.earthSphere != null) {
            geometries.add(this.earthSphere);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    public void setEarthLightingEnabled(boolean enable) {
        this.earthLightingEnabled = enable;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MoonSkyNodeJME3Object.this.updateEarthTexture();
                return null;
            }
        });
    }

    public boolean isEarthLightingEnabled() {
        return this.earthLightingEnabled;
    }

    public void setSunShadowsEnabled(boolean newSunShadowsEnabled) {
        this.sunShadowsEnabled = newSunShadowsEnabled;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MoonSkyNodeJME3Object.this.updateSun();
                MoonSkyNodeJME3Object.this.updateEarth();
                return null;
            }
        });
    }

    public boolean areSunShadowsEnabled() {
        return this.sunShadowsEnabled;
    }

    public void setEarthShadowsEnabled(boolean newEarthShadowsEnabled) {
        Logger.info("Setting EarthShadowsEnabled to <" + newEarthShadowsEnabled + ">.");
        this.earthShadowsEnabled = newEarthShadowsEnabled;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MoonSkyNodeJME3Object.this.updateSun();
                MoonSkyNodeJME3Object.this.updateEarth();
                return null;
            }
        });
    }

    public boolean areEarthShadowsEnabled() {
        return this.earthShadowsEnabled;
    }

    private boolean isSunCastingShadows() {
        return this.sunCastingShadows;
    }

    private boolean isSunVisible() {
        return this.sunVisible;
    }

    private boolean isMoonVisible() {
        return this.earthVisible;
    }

    private boolean isMoonCastingShadows() {
        return this.earthCastingShadows;
    }

    private void updateSunEarthVisibilityAndShadows() {
        TransformNode sunTranformNode = (TransformNode)this.moonSky.getSun().getParent();
        Matrix4d mSun = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)sunTranformNode);
        Vector3d vSun = new Vector3d();
        mSun.get(vSun);
        vSun.normalize();
        double rSun = vSun.length();
        double sunAltitude = Math.asin(vSun.z / rSun);
        this.sunVisible = this.isEarthLightingEnabled() ? true : sunAltitude > 0.0;
        this.sunCastingShadows = this.areSunShadowsEnabled() && this.sunVisible;
        TransformNode earthTranformNode = (TransformNode)this.moonSky.getEarth().getParent();
        Matrix4d mEarth = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)earthTranformNode);
        Vector3d vEarth = new Vector3d();
        mEarth.get(vEarth);
        vEarth.normalize();
        double rEarth = vEarth.length();
        double earthAltitude = Math.asin(vEarth.z / rEarth);
        this.earthVisible = earthAltitude > 0.0;
        boolean bl = this.earthCastingShadows = this.areEarthShadowsEnabled() && this.earthVisible && !this.sunVisible;
        if (this.isSunCastingShadows()) {
            this.setLightSourceCreatingShadow(this.getSunLight());
        } else if (this.isMoonCastingShadows()) {
            this.setLightSourceCreatingShadow(this.getEarthLight());
        } else {
            this.setLightSourceCreatingShadow(null);
        }
    }

    private void setLightSourceCreatingShadow(DirectionalLight light) {
        if (this.jme3Application != null) {
            if (light != null) {
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
                }
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getSunFilterPostProcessor());
                }
                this.getDirectionalLightShadowRenderer().setLight(light);
                this.getDirectionalLightShadowFilter().setLight(light);
            } else {
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
                }
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getSunFilterPostProcessor());
                }
            }
        }
    }

    private void enableBloom(boolean newEnableBloom) {
        this.enableBloom = newEnableBloom;
        if (this.jme3Application != null) {
            if (newEnableBloom) {
                if (!this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
                    this.jme3Application.getViewPort().addProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
                }
                Logger.info("Enabled Bloom.");
            } else {
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getBloomFilterPostProcessor())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getBloomFilterPostProcessor());
                }
                Logger.info("Disabled Bloom.");
            }
        }
    }

    private FilterPostProcessor getBloomFilterPostProcessor() {
        if (this.bloomFilterPostProcessor == null) {
            this.bloomFilterPostProcessor = new FilterPostProcessor(this.assetManager);
            this.bloomFilterPostProcessor.addFilter((Filter)this.getBloomFilter());
        }
        return this.bloomFilterPostProcessor;
    }

    private BloomFilter getBloomFilter() {
        if (this.bloomFilter == null) {
            this.bloomFilter = new BloomFilter(BloomFilter.GlowMode.Objects);
            this.bloomFilter.setDownSamplingFactor(2.0f);
            this.bloomFilter.setBlurScale(1.5f);
            this.bloomFilter.setExposurePower(3.3f);
            this.bloomFilter.setExposureCutOff(0.2f);
            this.bloomFilter.setBloomIntensity(20.0f);
        }
        return this.bloomFilter;
    }

    private void setShadowMapSize(int newShadowMapSize) {
        if (newShadowMapSize > 0) {
            this.shadowMapSize = newShadowMapSize;
            if (this.jme3Application != null) {
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getDirectionalLightShadowRenderer())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getDirectionalLightShadowRenderer());
                }
                if (this.jme3Application.getViewPort().getProcessors().contains(this.getSunFilterPostProcessor())) {
                    this.jme3Application.getViewPort().removeProcessor((SceneProcessor)this.getSunFilterPostProcessor());
                }
                this.shadowsFilterPostProcessor = null;
                this.directionalLightShadowRenderer = null;
                this.directionalLightShadowFilter = null;
                this.updateSunEarthVisibilityAndShadows();
            }
            Logger.info("Shadow Map Size set to <" + newShadowMapSize + ">.");
        } else {
            Logger.error("Cannot set shadow Map Size set to <" + newShadowMapSize + "> !");
        }
    }

    private DirectionalLightShadowRenderer getDirectionalLightShadowRenderer() {
        if (this.directionalLightShadowRenderer == null) {
            try {
                this.directionalLightShadowRenderer = new DirectionalLightShadowRenderer(this.assetManager, this.shadowMapSize, 3);
                this.directionalLightShadowRenderer.setLight(this.getSunLight());
                this.directionalLightShadowRenderer.setLambda(0.55f);
                this.directionalLightShadowRenderer.setShadowIntensity(0.6f);
                this.directionalLightShadowRenderer.setEdgeFilteringMode(EdgeFilteringMode.Nearest);
                this.directionalLightShadowRenderer.setEnabledStabilization(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.directionalLightShadowRenderer;
    }

    private FilterPostProcessor getSunFilterPostProcessor() {
        if (this.shadowsFilterPostProcessor == null) {
            this.shadowsFilterPostProcessor = new FilterPostProcessor(this.assetManager);
            this.shadowsFilterPostProcessor.addFilter((Filter)this.getDirectionalLightShadowFilter());
        }
        return this.shadowsFilterPostProcessor;
    }

    private DirectionalLightShadowFilter getDirectionalLightShadowFilter() {
        if (this.directionalLightShadowFilter == null) {
            this.directionalLightShadowFilter = new DirectionalLightShadowFilter(this.assetManager, this.shadowMapSize, 3);
            this.directionalLightShadowFilter.setLight(this.getSunLight());
            this.directionalLightShadowFilter.setLambda(0.55f);
            this.directionalLightShadowFilter.setShadowIntensity(0.6f);
            this.directionalLightShadowFilter.setEdgeFilteringMode(EdgeFilteringMode.Nearest);
            this.directionalLightShadowFilter.setEnabled(false);
        }
        return this.directionalLightShadowFilter;
    }

    private void attachSun() {
        this.getAttachmentNode().attachChild((Spatial)this.getSunTransform());
        this.getSunTransform().attachChild((Spatial)this.getSunSphere());
        if (this.jme3Application != null) {
            this.jme3Application.getRootNode().addLight((Light)this.getSunLight());
        }
    }

    private void updateSun() {
        this.updateSunEarthVisibilityAndShadows();
        TransformNode sunTranformNode = (TransformNode)this.moonSky.getSun().getParent();
        Vector3d v = new Vector3d(sunTranformNode.getPosition().asTuple3d());
        v.normalize();
        this.updateSunLight();
        v.scale(18000.0);
        this.getSunTransform().setLocalTranslation((float)v.x, (float)v.y, (float)v.z);
    }

    private StarFieldSceneObject resolveStarFieldSceneObject() {
        NodePresentation nodePresentation;
        StarField node;
        if (this.moonSky != null && (node = this.moonSky.getStarField()) != null && (nodePresentation = org.eclipse.apogy.common.topology.ui.Activator.getTopologyPresentationRegistry().getPresentationNode((Node)node)) instanceof StarFieldPresentation && nodePresentation.getSceneObject() instanceof StarFieldSceneObject) {
            return (StarFieldSceneObject)nodePresentation.getSceneObject();
        }
        return null;
    }

    private com.jme3.scene.Node getSunTransform() {
        if (this.sunTransform == null) {
            this.sunTransform = new com.jme3.scene.Node("Sun Transform");
        }
        return this.sunTransform;
    }

    private Geometry getSunSphere() {
        if (this.sunSphere == null) {
            float sunRadius = (float)(18000.0 * Math.tan(this.moonSky.getSunAngularDiameter() / 2.0));
            Sphere sphere = new Sphere(10, 36, sunRadius);
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setColor("GlowColor", SUN_SPHERE_COLOR.clone());
            mat.setColor("Color", SUN_SPHERE_COLOR.clone());
            mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            this.sunSphere = new Geometry("Sun", (Mesh)sphere);
            this.sunSphere.setMaterial(mat);
            this.sunSphere.setShadowMode(RenderQueue.ShadowMode.Off);
        }
        return this.sunSphere;
    }

    private DirectionalLight getSunLight() {
        if (this.sunLight == null) {
            TransformNode sunTransformNode = (TransformNode)this.moonSky.getSun().getParent();
            float x = (float)sunTransformNode.getPosition().getX();
            float y = (float)sunTransformNode.getPosition().getY();
            float z = (float)sunTransformNode.getPosition().getZ();
            Vector3f direction = new Vector3f(x, y, z);
            this.sunLight = new DirectionalLight();
            this.sunLight.setName("Sun");
            this.sunLight.setDirection(direction.normalize());
            this.sunLight.setColor(this.getSunColor(direction));
        }
        return this.sunLight;
    }

    private void updateSunLight() {
        TransformNode sunTranformNode = (TransformNode)this.moonSky.getSun().getParent();
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)sunTranformNode);
        Vector3d v = new Vector3d();
        m.get(v);
        v.normalize();
        Vector3f direction = new Vector3f((float)v.x, (float)v.y, (float)v.z);
        ColorRGBA color = this.getSunColor(direction);
        this.getSunLight().setColor(color);
        direction.negateLocal();
        this.getSunLight().setDirection(direction.normalize());
    }

    private ColorRGBA getSunColor(Vector3f sunPosition) {
        ColorRGBA sunColor = null;
        sunColor = this.isSunVisible() ? JME3Utilities.convertToColorRGBA((RGB)new RGB(255, 255, 255)) : ColorRGBA.BlackNoAlpha;
        return sunColor;
    }

    private void attachEarth() {
        this.getAttachmentNode().attachChild((Spatial)this.getEarthTransform());
        this.getEarthTransform().attachChild((Spatial)this.getEarthSphere());
        if (this.jme3Application instanceof JME3Application) {
            JME3Application viewer = this.jme3Application;
            viewer.getRootNode().addLight((Light)this.getEarthLight());
        }
    }

    private void updateEarth() {
        this.updateSunEarthVisibilityAndShadows();
        TransformNode moonTranformNode = (TransformNode)this.moonSky.getEarth().getParent();
        Vector3d v = new Vector3d(moonTranformNode.getPosition().asTuple3d());
        v.normalize();
        v.scale(18000.0);
        this.getEarthTransform().setLocalTranslation((float)v.x, (float)v.y, (float)v.z);
        Matrix3x3 rot = this.moonSky.getEarthOrientation();
        if (rot != null) {
            Matrix3f rotation = new Matrix3f((float)rot.getM00(), (float)rot.getM01(), (float)rot.getM02(), (float)rot.getM10(), (float)rot.getM11(), (float)rot.getM12(), (float)rot.getM20(), (float)rot.getM21(), (float)rot.getM22());
            this.getEarthTransform().setLocalRotation(rotation);
        }
        this.updateEarthLight();
    }

    private void updateEarthLight() {
        TransformNode moonTranformNode = (TransformNode)this.moonSky.getEarth().getParent();
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame((Node)moonTranformNode);
        Vector3d v = new Vector3d();
        m.get(v);
        v.normalize();
        Vector3f direction = new Vector3f((float)v.x, (float)v.y, (float)v.z);
        ColorRGBA color = this.getEarthColor(direction);
        this.getEarthLight().setColor(color);
        direction.negateLocal();
        this.getEarthLight().setDirection(direction.normalize());
    }

    private void updateEarthTexture() {
        if (this.earthSphere != null) {
            this.earthSphere.setMaterial(this.createEarthMaterial());
        }
    }

    private DirectionalLight getEarthLight() {
        if (this.earthLight == null) {
            TransformNode sunTransformNode = (TransformNode)this.moonSky.getEarth().getParent();
            float x = (float)sunTransformNode.getPosition().getX();
            float y = (float)sunTransformNode.getPosition().getY();
            float z = (float)sunTransformNode.getPosition().getZ();
            Vector3f direction = new Vector3f(x, y, z);
            this.earthLight = new DirectionalLight();
            this.earthLight.setName("Earth");
            this.earthLight.setDirection(direction.normalize());
            this.earthLight.setColor(this.getEarthColor(direction));
        }
        return this.earthLight;
    }

    private ColorRGBA getEarthColor(Vector3f moonPosition) {
        ColorRGBA earthColor = null;
        earthColor = this.sunVisible ? new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f) : (this.isMoonVisible() ? JME3Utilities.convertToColorRGBA((RGB)new RGB(128, 128, 128)) : ColorRGBA.BlackNoAlpha);
        return earthColor;
    }

    private com.jme3.scene.Node getEarthTransform() {
        if (this.earthTransform == null) {
            this.earthTransform = new com.jme3.scene.Node("Earth Transform");
            Matrix3f rotation = new Matrix3f();
            rotation.fromAngleAxis((float)Math.toRadians(90.0), new Vector3f(0.0f, 0.0f, 1.0f));
            this.earthTransform.setLocalRotation(rotation);
        }
        return this.earthTransform;
    }

    private Geometry getEarthSphere() {
        if (this.earthSphere == null) {
            float earthRadius = (float)(18000.0 * Math.tan(this.moonSky.getEarthAngularDiameter() / 2.0));
            Sphere sphere = new Sphere(10, 36, earthRadius);
            sphere.setTextureMode(Sphere.TextureMode.Projected);
            this.earthSphere = new Geometry("Earth", (Mesh)sphere);
            this.earthSphere.setMaterial(this.createEarthMaterial());
            this.earthSphere.setShadowMode(RenderQueue.ShadowMode.Off);
            Quaternion rotation = new Quaternion();
            rotation.fromAngles(0.0f, 0.0f, (float)Math.PI);
            this.earthSphere.setLocalRotation(rotation);
        }
        return this.earthSphere;
    }

    private Material createEarthMaterial() {
        Material mat = null;
        String earthTextureAssetLocation = "/Textures/earth.jpg";
        Texture earthTexture = null;
        try {
            earthTexture = this.assetManager.loadTexture(earthTextureAssetLocation);
        }
        catch (Exception e) {
            Logger.error("Could not load texture for Earth !", (Throwable)e);
            earthTexture = null;
        }
        if (this.isEarthLightingEnabled()) {
            mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            String earthGlowTextureAssetLocation = "/Textures/earth_at_night.jpg";
            Texture earthGlowTexture = null;
            try {
                earthGlowTexture = this.assetManager.loadTexture(earthGlowTextureAssetLocation);
            }
            catch (Exception e) {
                Logger.error("Could not load texture for Earth at Night!", (Throwable)e);
            }
            if (earthTexture != null) {
                mat.setTexture("DiffuseMap", earthTexture);
            } else {
                mat.setBoolean("UseMaterialColors", true);
                mat.setColor("Ambient", EARTH_SPHERE_COLOR.clone());
                mat.setColor("Diffuse", EARTH_SPHERE_COLOR.clone());
            }
            if (earthGlowTexture != null) {
                mat.setTexture("GlowMap", earthGlowTexture);
            }
            return mat;
        }
        mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        if (earthTexture != null) {
            mat.setTexture("ColorMap", earthTexture);
        } else {
            mat.setColor("Color", EARTH_SPHERE_COLOR.clone());
        }
        return mat;
    }

    private Adapter getSunAdapter() {
        if (this.sunAdapter == null) {
            this.sunAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    MoonSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            MoonSkyNodeJME3Object.this.updateSun();
                            return null;
                        }
                    });
                }
            };
        }
        return this.sunAdapter;
    }

    private Adapter getEarthAdapter() {
        if (this.earthAdapter == null) {
            this.earthAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    MoonSkyNodeJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            MoonSkyNodeJME3Object.this.updateEarth();
                            return null;
                        }
                    });
                }
            };
        }
        return this.earthAdapter;
    }
}

